/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.report;

import java.util.Collections;
import java.util.List;
import org.squashtest.tm.api.report.form.BasicInput;
import org.squashtest.tm.api.report.form.CheckboxInput;
import org.squashtest.tm.api.report.form.ContainerOption;
import org.squashtest.tm.api.report.form.InputType;
import org.squashtest.tm.api.report.form.MilestonePicker;
import org.squashtest.tm.api.report.form.OptionInput;
import org.squashtest.tm.api.report.form.OptionInputVisitor;
import org.squashtest.tm.api.report.form.OptionsGroup;
import org.squashtest.tm.api.report.form.ProjectPicker;
import org.squashtest.tm.api.report.form.TagPicker;
import org.squashtest.tm.api.report.form.TreePicker;
import org.squashtest.tm.api.report.form.composite.MilestonePickerOption;
import org.squashtest.tm.api.report.form.composite.ProjectPickerOption;
import org.squashtest.tm.api.report.form.composite.TagPickerOption;
import org.squashtest.tm.api.report.form.composite.TreePickerOption;
import org.squashtest.tm.web.backend.controller.report.BasicInputJson;
import org.squashtest.tm.web.backend.controller.report.OptionInputJson;

public class OptionsGroupJson
extends BasicInputJson {
    private List<OptionInputJson> options = Collections.emptyList();

    public OptionsGroupJson(OptionsGroup input) {
        super((BasicInput)input);
        this.options = input.getOptions().stream().map(OptionsGroupJson::fromOptionInput).toList();
    }

    public List<OptionInputJson> getOptions() {
        return this.options;
    }

    public static OptionInputJson fromOptionInput(final OptionInput optionInput) {
        final OptionInputJson[] optionInputJsons = new OptionInputJson[1];
        OptionInputVisitor optionInputVisitor = new OptionInputVisitor(){

            public void visit(ContainerOption<?> containerOption) {
                OptionInputJson optionInputJson = new OptionInputJson((OptionInput)containerOption);
                optionInputJson.setComposite(true);
                optionInputJson.setContentType(containerOption.getContent().getType());
                optionInputJsons[0] = optionInputJson;
            }

            public void visit(MilestonePickerOption milestonePickerOption) {
                OptionInputJson optionInputJson = new OptionInputJson((OptionInput)milestonePickerOption);
                optionInputJson.setComposite(true);
                optionInputJson.setContentType(((MilestonePicker)milestonePickerOption.getContent()).getType());
                optionInputJsons[0] = optionInputJson;
            }

            public void visit(ProjectPickerOption projectPickerOption) {
                OptionInputJson optionInputJson = new OptionInputJson((OptionInput)projectPickerOption);
                optionInputJson.setComposite(true);
                optionInputJson.setContentType(((ProjectPicker)projectPickerOption.getContent()).getType());
                optionInputJsons[0] = optionInputJson;
            }

            public void visit(TagPickerOption tagPickerOption) {
                OptionInputJson.TagPickerOptionJson optionInputJson = new OptionInputJson.TagPickerOptionJson(tagPickerOption);
                optionInputJson.setComposite(true);
                optionInputJson.setContentType(((TagPicker)tagPickerOption.getContent()).getType());
                optionInputJsons[0] = optionInputJson;
            }

            public void visit(TreePickerOption treePickerOption) {
                OptionInputJson.TreePickerOptionJson optionInputJson = new OptionInputJson.TreePickerOptionJson(treePickerOption);
                optionInputJson.setComposite(true);
                optionInputJson.setContentType(((TreePicker)treePickerOption.getContent()).getType());
                optionInputJsons[0] = optionInputJson;
            }

            public void visit(CheckboxInput checkboxInput) {
                OptionInputJson optionInputJson = new OptionInputJson(optionInput);
                optionInputJson.setComposite(true);
                optionInputJson.setContentType(InputType.CHECKBOX);
                optionInputJsons[0] = optionInputJson;
            }

            public void visit(OptionInput optionInput2) {
                OptionInputJson optionInputJson = new OptionInputJson(optionInput2);
                optionInputJson.setComposite(true);
                optionInputJson.setContentType(InputType.CHECKBOX);
                optionInputJsons[0] = optionInputJson;
            }
        };
        optionInput.accept(optionInputVisitor);
        return optionInputJsons[0];
    }
}

