/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.issue;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import org.springframework.context.MessageSource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.csp.core.bugtracker.domain.BTIssue;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.bugtracker.BugTrackersLocalService;
import org.squashtest.tm.service.internal.bugtracker.knownissues.remote.IssueHolderEntityType;
import org.squashtest.tm.service.internal.configuration.CallbackUrlProvider;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.remoteissue.RemoteIssueDisplayService;
import org.squashtest.tm.service.remoteissue.RemoteIssueReportService;
import org.squashtest.tm.service.testautomation.spi.BadConfiguration;
import org.squashtest.tm.web.backend.controller.bugtracker.BugTrackerControllerHelper;
import org.squashtest.tm.web.i18n.InternationalizationHelper;
import oslcdomain.OslcIssue;

@RestController
@RequestMapping(value={"/backend/issues"})
public class RemoteIssueReportFailureDetailController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteIssueReportFailureDetailController.class);
    private final CallbackUrlProvider callbackUrlProvider;
    private final RemoteIssueReportService remoteIssueReportService;
    private final InternationalizationHelper messageSource;
    private final RemoteIssueDisplayService remoteIssueDisplayService;
    private final BugTrackersLocalService bugTrackersLocalService;

    public RemoteIssueReportFailureDetailController(CallbackUrlProvider callbackUrlProvider, RemoteIssueReportService remoteIssueReportService, InternationalizationHelper messageSource, RemoteIssueDisplayService remoteIssueDisplayService, BugTrackersLocalService bugTrackersLocalService) {
        this.callbackUrlProvider = callbackUrlProvider;
        this.remoteIssueReportService = remoteIssueReportService;
        this.messageSource = messageSource;
        this.remoteIssueDisplayService = remoteIssueDisplayService;
        this.bugTrackersLocalService = bugTrackersLocalService;
    }

    @GetMapping(value={"failure-detail/{failureDetailId}/new-issue"})
    public RemoteIssue getFailureDetailReportStub(@PathVariable Long failureDetailId, HttpServletRequest request, @RequestParam(value="project-name") String projectName, @RequestParam(value="extender-id") Long extenderId) {
        return this.remoteIssueReportService.makeFailureDetailReportIssueModel(failureDetailId.longValue(), extenderId.longValue(), projectName, this.getSquashPublicUrl(request), (MessageSource)this.messageSource);
    }

    @PostMapping(value={"failure-detail/{failureDetailId}/new-issue"})
    public Map<String, String> postFailureDetailIssueReport(@PathVariable Long failureDetailId, @RequestBody BTIssue jsonIssue, @RequestParam(value="extender-id") Long extenderId) {
        return this.remoteIssueReportService.postFailureDetailIssueReport(failureDetailId.longValue(), extenderId.longValue(), (RemoteIssue)jsonIssue);
    }

    @PostMapping(value={"failure-detail/{failureDetailId}/new-advanced-issue"})
    public Map<String, String> postFailureDetailAdvancedIssueReport(@PathVariable Long failureDetailId, @RequestBody AdvancedIssue jsonIssue, @RequestParam(value="extender-id") Long extenderId) {
        return this.remoteIssueReportService.postFailureDetailIssueReport(failureDetailId.longValue(), extenderId.longValue(), (RemoteIssue)jsonIssue);
    }

    @PostMapping(value={"failure-detail/{failureDetailId}/new-oslc-issue"})
    public void postFailureDetailOslcIssueReport(@PathVariable Long failureDetailId, @RequestBody NewOslcIssueRequestBody requestBody, @RequestParam(value="extender-id") Long extenderId) {
        OslcIssue oslcIssue = new OslcIssue();
        oslcIssue.setId(requestBody.issueId);
        this.remoteIssueReportService.postFailureDetailOslcIssue(failureDetailId.longValue(), extenderId.longValue(), oslcIssue);
    }

    @PostMapping(value={"execution-extender/{extenderId}/all-failure-detail-issues"})
    public GridResponse getExecFailureDetailKnownIssuesDataWithoutPaging(@PathVariable Long extenderId) {
        return this.remoteIssueDisplayService.buildAllKnownIssuesGrid(IssueHolderEntityType.FAILURE_DETAIL.getValue(), extenderId.longValue());
    }

    @DeleteMapping(value={"/automated/{extenderId}/remote-issues/{issueIds}"})
    public void detachIssuesAndUpdateAutomationFlag(@PathVariable Long extenderId, @PathVariable List<Long> issueIds) {
        this.bugTrackersLocalService.detachIssuesAndUpdateAutomationFlag(issueIds, extenderId);
    }

    private String getSquashPublicUrl(HttpServletRequest request) {
        try {
            return this.callbackUrlProvider.getCallbackUrl().toExternalForm();
        }
        catch (BadConfiguration badConfigurationException) {
            LOGGER.debug("Could not get squash public url.", (Throwable)badConfigurationException);
            return BugTrackerControllerHelper.extractBaseUrl(request);
        }
    }

    public static class NewOslcIssueRequestBody {
        String issueId;

        public String getIssueId() {
            return this.issueId;
        }
    }
}

