/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.infolist;

import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.infolist.UserListItem;
import org.squashtest.tm.service.display.infolist.InfoListDisplayService;
import org.squashtest.tm.service.infolist.InfoListItemManagerService;
import org.squashtest.tm.service.infolist.InfoListManagerService;
import org.squashtest.tm.service.internal.display.dto.InfoListAdminViewDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.web.backend.controller.form.model.InfoListFormModel;

@RestController
@RequestMapping(value={"/backend/info-lists"})
public class InfoListController {
    private final InfoListDisplayService infoListDisplayService;
    private final InfoListManagerService infoListManagerService;
    private final InfoListItemManagerService infoListItemManagerService;

    @Inject
    InfoListController(InfoListDisplayService infoListDisplayService, InfoListManagerService infoListManagerService, InfoListItemManagerService infoListItemManagerService) {
        this.infoListDisplayService = infoListDisplayService;
        this.infoListManagerService = infoListManagerService;
        this.infoListItemManagerService = infoListItemManagerService;
    }

    @PostMapping
    public GridResponse getAllUserInfoLists(@RequestBody GridRequest request) {
        return this.infoListDisplayService.findAll(request);
    }

    @DeleteMapping(value={"/{listIds}"})
    public void deleteInfoLists(@PathVariable List<Long> listIds) {
        this.infoListManagerService.remove(listIds);
    }

    @PostMapping(value={"/new"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public Map<String, Object> createInfoList(@RequestBody InfoListFormModel infoListFormModel) {
        InfoList infoList = infoListFormModel.getInfoList();
        this.infoListManagerService.persist(infoList);
        return Collections.singletonMap("id", infoList.getId());
    }

    @PostMapping(value={"/{infoListId}/label"})
    public void changeLabel(@PathVariable long infoListId, @RequestBody InfoListPatch patch) {
        this.infoListManagerService.changeLabel(infoListId, patch.getLabel());
    }

    @PostMapping(value={"/{infoListId}/description"})
    public void changeDescription(@PathVariable long infoListId, @RequestBody InfoListPatch patch) {
        this.infoListManagerService.changeDescription(infoListId, patch.getDescription());
    }

    @PostMapping(value={"/{infoListId}/code"})
    public void changeCode(@PathVariable long infoListId, @RequestBody InfoListPatch patch) {
        this.infoListManagerService.changeCode(infoListId, patch.getCode());
    }

    @PostMapping(value={"/{infoListId}/items/new"})
    public InfoListAdminViewDto addItem(@PathVariable long infoListId, @RequestBody NewInfoListItem newItem) {
        this.infoListItemManagerService.checkCodePattern(newItem.getCode());
        this.infoListItemManagerService.checkIfCodeAlreadyExists(newItem.getCode());
        UserListItem item = new UserListItem();
        item.setCode(newItem.getCode());
        item.setLabel(newItem.getLabel());
        item.setColour(newItem.getColour());
        item.setIconName(newItem.getIconName());
        this.infoListItemManagerService.addInfoListItem(infoListId, (InfoListItem)item);
        return this.infoListDisplayService.getInfoListView(infoListId);
    }

    @GetMapping(value={"/check-if-item-code-already-exists/{code}"})
    public void checkIfItemCodeAlreadyExists(@PathVariable String code) {
        this.infoListItemManagerService.checkIfCodeAlreadyExists(code);
    }

    public static class InfoListPatch {
        private String label;
        private String code;
        private String description;

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    public static class NewInfoListItem {
        String code;
        String label;
        String iconName;
        String colour;

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getIconName() {
            return this.iconName;
        }

        public void setIconName(String iconName) {
            this.iconName = iconName;
        }

        public String getColour() {
            return this.colour;
        }

        public void setColour(String colour) {
            this.colour = colour;
        }
    }
}

