/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.infolist;

import jakarta.inject.Inject;
import java.util.Map;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.infolist.InfoListBindingManagerService;

@RestController
@RequestMapping(value={"/backend/info-list-binding"})
public class InfoListBindingController {
    private static final String INFO_LIST_ID = "infoListId";
    private final InfoListBindingManagerService infoListBindingManagerService;

    @Inject
    InfoListBindingController(InfoListBindingManagerService infoListBindingManagerService) {
        this.infoListBindingManagerService = infoListBindingManagerService;
    }

    @PostMapping(value={"/project/{projectId}/category"})
    public void bindCategoryToProject(@PathVariable Long projectId, @RequestBody Map<String, Long> request) {
        this.infoListBindingManagerService.bindListToProjectReqCategory(request.get(INFO_LIST_ID).longValue(), projectId.longValue());
    }

    @PostMapping(value={"/project/{projectId}/nature"})
    public void bindNatureToProject(@PathVariable Long projectId, @RequestBody Map<String, Long> request) {
        this.infoListBindingManagerService.bindListToProjectTcNature(request.get(INFO_LIST_ID).longValue(), projectId.longValue());
    }

    @PostMapping(value={"/project/{projectId}/type"})
    public void bindTypeToProject(@PathVariable Long projectId, @RequestBody Map<String, Long> request) {
        this.infoListBindingManagerService.bindListToProjectTcType(request.get(INFO_LIST_ID).longValue(), projectId.longValue());
    }
}

