/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.importer.testcase;

import jakarta.inject.Inject;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartFile;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;
import org.squashtest.tm.web.backend.controller.importer.ImportExcelResponse;
import org.squashtest.tm.web.backend.controller.importer.testcase.TestCaseImportHelper;

@RestController
@RequestMapping(value={"backend/test-cases/importer"})
public class TestCaseImportController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCaseImportController.class);
    @Inject
    private TestCaseLibraryNavigationService navigationService;
    @Inject
    private TestCaseImportHelper importHelper;

    @PostMapping(value={"/xls"}, params={"dry-run"})
    public ImportExcelResponse dryRunExcelWorkbook(@RequestParam(value="archive") MultipartFile uploadedFile, WebRequest request) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("dryRunExcelWorkbook", new Object[0]);
        }
        return this.importHelper.importWorkbook("test-cases", uploadedFile, xls -> this.navigationService.simulateImportExcelTestCase(xls));
    }

    @PostMapping(value={"/xls"}, params={"!dry-run"})
    public ImportExcelResponse importExcelWorkbook(@RequestParam(value="archive") MultipartFile uploadedFile) {
        return this.importHelper.importWorkbook("test-cases", uploadedFile, xls -> this.navigationService.performImportExcelTestCase(xls));
    }
}

