/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.importer.requirement;

import jakarta.inject.Inject;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.web.backend.controller.importer.ImportExcelResponse;
import org.squashtest.tm.web.backend.controller.importer.requirement.RequirementImportHelper;

@RestController
@RequestMapping(value={"backend/requirement/importer"})
public class RequirementImportController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementImportController.class);
    @Inject
    private RequirementLibraryNavigationService navigationService;
    @Inject
    private RequirementImportHelper importHelper;

    @PostMapping(value={"/xls"}, params={"dry-run"})
    public ImportExcelResponse dryRunExcelWorkbook(@RequestParam(value="archive") MultipartFile uploadedFile) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("dryRunExcelWorkbook", new Object[0]);
        }
        return this.importHelper.importWorkbook("requirement", uploadedFile, xls -> this.navigationService.simulateImportExcelRequirement(xls));
    }

    @PostMapping(value={"/xls"}, params={"!dry-run"})
    public ImportExcelResponse importExcelWorkbook(@RequestParam(value="archive") MultipartFile uploadedFile) {
        return this.importHelper.importWorkbook("requirement", uploadedFile, xls -> this.navigationService.importExcelRequirement(xls));
    }
}

