/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.home;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;
import org.squashtest.tm.service.plugin.PluginFinderService;
import org.squashtest.tm.service.system.SystemAdministrationService;

@RestController
@RequestMapping(value={"backend/login-page"})
public class LoginPageController {
    private final SystemAdministrationService systemAdministrationService;
    private final PluginFinderService pluginFinderService;
    @Value(value="${info.app.version}")
    private String version;
    @Autowired
    private Environment environment;
    @Autowired(required=false)
    private OAuth2ClientProperties oAuth2ClientProperties;

    public LoginPageController(SystemAdministrationService systemAdministrationService, PluginFinderService pluginFinderService) {
        this.systemAdministrationService = systemAdministrationService;
        this.pluginFinderService = pluginFinderService;
    }

    @GetMapping
    public WelcomePageData loadLoginPage() {
        String loginMessage = this.systemAdministrationService.findLoginMessage();
        boolean isH2 = this.isH2();
        boolean isOpenIdConnectPluginInstalled = this.isOpenIdConnectPluginInstalled();
        List<OAuth2ProviderDto> oAuth2Providers = this.getConfiguredOAuth2ProviderDtos();
        return new WelcomePageData(loginMessage, this.version, isH2, isOpenIdConnectPluginInstalled, oAuth2Providers);
    }

    private boolean isH2() {
        List<String> activeProfiles = Arrays.asList(this.environment.getActiveProfiles());
        return activeProfiles.contains("h2");
    }

    private boolean isOpenIdConnectPluginInstalled() {
        return this.pluginFinderService.isOpenIdConnectPluginInstalled();
    }

    private List<OAuth2ProviderDto> getConfiguredOAuth2ProviderDtos() {
        if (this.oAuth2ClientProperties != null && !this.oAuth2ClientProperties.getRegistration().isEmpty()) {
            return this.oAuth2ClientProperties.getRegistration().entrySet().stream().map(entry -> new OAuth2ProviderDto((String)entry.getKey(), ((OAuth2ClientProperties.Registration)entry.getValue()).getClientName())).sorted(Comparator.comparing(dto -> Optional.ofNullable(dto.displayName()).orElse(dto.registrationName()), Comparator.naturalOrder())).toList();
        }
        return Collections.emptyList();
    }

    public record OAuth2ProviderDto(String registrationName, String displayName) {
    }

    static class WelcomePageData {
        private final String loginMessage;
        private final String squashVersion;
        private final boolean isH2;
        private final boolean isOpenIdConnectPluginInstalled;
        private final List<OAuth2ProviderDto> oAuth2ProviderNames;

        public WelcomePageData(String loginMessage, String squashVersion, boolean isH2, boolean isOpenIdConnectPluginInstalled, List<OAuth2ProviderDto> oAuth2ProviderNames) {
            this.loginMessage = HTMLCleanupUtils.cleanHtml((String)loginMessage);
            this.squashVersion = squashVersion;
            this.isH2 = isH2;
            this.isOpenIdConnectPluginInstalled = isOpenIdConnectPluginInstalled;
            this.oAuth2ProviderNames = oAuth2ProviderNames;
        }

        public String getLoginMessage() {
            return this.loginMessage;
        }

        public String getSquashVersion() {
            return this.squashVersion;
        }

        public List<OAuth2ProviderDto> getOAuth2ProviderNames() {
            return this.oAuth2ProviderNames;
        }

        @JsonProperty(value="isH2")
        public boolean isH2() {
            return this.isH2;
        }

        @JsonProperty(value="isOpenIdConnectPluginInstalled")
        public boolean isOpenIdConnectPluginInstalled() {
            return this.isOpenIdConnectPluginInstalled;
        }
    }
}

