/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.execution;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.service.display.execution.ExecutionDisplayService;
import org.squashtest.tm.service.execution.ExecutionProcessingService;
import org.squashtest.tm.service.internal.display.dto.execution.ExecutionStepView;
import org.squashtest.tm.service.internal.display.dto.execution.ExecutionView;

@RestController
@RequestMapping(value={"/backend/execution-step/{stepId}"})
public class ExecutionStepController {
    private final ExecutionProcessingService executionProcessingService;
    private final ExecutionDisplayService executionDisplayService;

    public ExecutionStepController(ExecutionProcessingService executionProcessingService, ExecutionDisplayService executionDisplayService) {
        this.executionProcessingService = executionProcessingService;
        this.executionDisplayService = executionDisplayService;
    }

    @PostMapping(value={"/status"})
    public Map<String, Object> updateExecutionStatus(@RequestBody ExecutionStepPatch patch, @PathVariable long stepId, @RequestParam(value="executionId") Long executionId) {
        ExecutionStatus status = ExecutionStatus.valueOf((String)patch.executionStatus);
        this.executionProcessingService.changeExecutionStepStatus(Long.valueOf(stepId), status);
        ExecutionView execution = this.executionDisplayService.findOne(executionId);
        Optional<ExecutionStepView> executionStep = execution.getExecutionStepViews().stream().filter(step -> step.getId() == stepId).findAny();
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("executionStatus", execution.getExecutionStatus());
        response.put("lastExecutedOn", execution.getLastExecutedOn());
        response.put("lastExecutedBy", execution.getLastExecutedBy());
        executionStep.ifPresent(step -> {
            response.put("stepLastExecutedOn", step.getLastExecutedOn());
            response.put("stepLastExecutedBy", step.getLastExecutedBy());
        });
        return response;
    }

    @RequestMapping(value={"/comment"})
    public void changeComment(@RequestBody ExecutionStepPatch patch, @PathVariable long stepId) {
        this.executionProcessingService.setExecutionStepComment(Long.valueOf(stepId), patch.comment);
    }

    static class ExecutionStepPatch {
        private String executionStatus;
        private String comment;

        ExecutionStepPatch() {
        }

        public String getExecutionStatus() {
            return this.executionStatus;
        }

        public void setExecutionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }
    }
}

