/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.execution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.service.bugtracker.knownissues.remote.RemoteKnownIssueFinder;
import org.squashtest.tm.service.campaign.CustomIterationModificationService;
import org.squashtest.tm.service.display.execution.ExecutionDisplayService;
import org.squashtest.tm.service.execution.ExecutionModificationService;
import org.squashtest.tm.service.internal.display.dto.AttachmentListDto;
import org.squashtest.tm.service.internal.display.dto.execution.ActionStepExecView;
import org.squashtest.tm.service.internal.display.dto.execution.ExecutionView;
import org.squashtest.tm.service.internal.display.dto.execution.ModificationDuringExecutionView;
import org.squashtest.tm.web.backend.controller.form.model.CreatedEntityId;

@RestController
@RequestMapping(value={"/backend/execution/{executionId}"})
public class ExecutionController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionController.class);
    private final ExecutionDisplayService executionDisplayService;
    private final ExecutionModificationService executionModificationService;
    private final CustomIterationModificationService itpService;
    private final RemoteKnownIssueFinder remoteKnownIssueFinder;

    public ExecutionController(ExecutionDisplayService executionDisplayService, ExecutionModificationService executionModificationService, CustomIterationModificationService itpService, RemoteKnownIssueFinder remoteKnownIssueFinder) {
        this.executionDisplayService = executionDisplayService;
        this.executionModificationService = executionModificationService;
        this.itpService = itpService;
        this.remoteKnownIssueFinder = remoteKnownIssueFinder;
    }

    @GetMapping
    public ExecutionView getExecutionView(@PathVariable(value="executionId") long executionId) {
        return this.executionDisplayService.findOne(Long.valueOf(executionId));
    }

    @GetMapping(value={"attachments"})
    public AttachmentListDto getReportUrls(@PathVariable(value="executionId") long executionId) {
        return this.executionDisplayService.findAttachmentList(Long.valueOf(executionId));
    }

    @GetMapping(value={"/modification-during-execution/permissions"})
    public void checkPermissions(@PathVariable long executionId) {
        this.executionDisplayService.checkPermissionsForModificationDuringExecutionPrologue(executionId);
    }

    @GetMapping(value={"/modification-during-execution/permissions/{stepId}"})
    public void checkPermissions(@PathVariable long executionId, @PathVariable long stepId) {
        this.executionDisplayService.checkPermissionsForModificationDuringExecution(executionId, stepId);
    }

    @GetMapping(value={"/modification-during-execution"})
    public ModificationDuringExecutionView getModificationDuringExecutionView(@PathVariable long executionId) {
        return this.executionDisplayService.findOneForModificationDuringExec(Long.valueOf(executionId));
    }

    @GetMapping(value={"/modification-during-execution/action-step/{stepId}"})
    public ActionStepExecView getActionStepDuringExecutionView(@PathVariable long executionId, @PathVariable long stepId) {
        return this.executionDisplayService.findOneActionStepForModificationDuringExec(executionId, stepId);
    }

    @PostMapping(value={"/modification-during-execution/update-steps"})
    public Long updateSteps(@PathVariable(value="executionId") long executionId) {
        return this.executionModificationService.updateSteps(executionId);
    }

    @PostMapping(value={"/comment"})
    public void updateComment(@RequestBody ExecutionPatch executionPatch, @PathVariable long executionId) {
        this.executionModificationService.setExecutionDescription(Long.valueOf(executionId), executionPatch.comment);
        LOGGER.trace("Execution {}: updated description to {}", new Object[]{executionId, executionPatch.comment});
    }

    @PostMapping(value={"/update-from-tc"})
    public CreatedEntityId updateExecutionFromTc(@PathVariable long executionId) {
        Execution exec = this.itpService.updateExecutionFromTc(executionId);
        return new CreatedEntityId(exec.getId());
    }

    @GetMapping(value={"issue-count"})
    public Map<String, Integer> getIssueCount(@PathVariable long executionId) {
        return Collections.singletonMap("issueCount", this.remoteKnownIssueFinder.getCountForExecution(Long.valueOf(executionId)));
    }

    @PostMapping(value={"move-notes"})
    public void changeNotesIndex(@PathVariable long executionId, @RequestBody MoveNotesModel moveNotesModel) {
        this.executionModificationService.changeNotesIndex(executionId, moveNotesModel.newIndex, moveNotesModel.movedNoteIds);
    }

    static class ExecutionPatch {
        private String comment;

        ExecutionPatch() {
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }
    }

    public static class MoveNotesModel {
        private List<Long> movedNoteIds = new ArrayList<Long>();
        private Integer newIndex;

        public List<Long> getMovedNoteIds() {
            return this.movedNoteIds;
        }

        public void setMovedNoteIds(List<Long> movedNoteIds) {
            this.movedNoteIds = movedNoteIds;
        }

        public Integer getNewIndex() {
            return this.newIndex;
        }

        public void setNewIndex(Integer newIndex) {
            this.newIndex = newIndex;
        }
    }
}

