/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.entitypath;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.internal.display.dto.PathNodeDto;
import org.squashtest.tm.service.internal.library.EntityPathHeaderService;

@RestController
@RequestMapping(value={"/backend/entity-path-header"})
public class EntityPathHeaderController {
    private static final String BREADCRUMBS = "breadcrumbs";
    private final EntityPathHeaderService entityPathHeaderService;

    public EntityPathHeaderController(EntityPathHeaderService entityPathHeaderService) {
        this.entityPathHeaderService = entityPathHeaderService;
    }

    @GetMapping(value={"campaign/{campaignId}"})
    Map<String, List<PathNodeDto>> getCampaignPathHeader(@PathVariable Long campaignId) {
        return Collections.singletonMap(BREADCRUMBS, this.entityPathHeaderService.getCampaignLibraryNodeHeaderBreadcrumbs(campaignId, true));
    }

    @GetMapping(value={"campaign-folder/{campaignFolderId}"})
    Map<String, List<PathNodeDto>> getCampaignFolderPathHeader(@PathVariable Long campaignFolderId) {
        return Collections.singletonMap(BREADCRUMBS, this.entityPathHeaderService.getCampaignLibraryNodeHeaderBreadcrumbs(campaignFolderId, true));
    }

    @GetMapping(value={"iteration/{iterationId}"})
    Map<String, List<PathNodeDto>> getIterationPathHeader(@PathVariable Long iterationId) {
        return Collections.singletonMap(BREADCRUMBS, this.entityPathHeaderService.getIterationHeaderBreadcrumbs(iterationId));
    }

    @GetMapping(value={"sprint/{sprintId}"})
    Map<String, List<PathNodeDto>> getSprintPathHeader(@PathVariable Long sprintId) {
        return Collections.singletonMap(BREADCRUMBS, this.entityPathHeaderService.getCampaignLibraryNodeHeaderBreadcrumbs(sprintId, true));
    }

    @GetMapping(value={"sprint-group/{sprintGroupId}"})
    Map<String, List<PathNodeDto>> getSprintGroupPathHeader(@PathVariable Long sprintGroupId) {
        return Collections.singletonMap(BREADCRUMBS, this.entityPathHeaderService.getCampaignLibraryNodeHeaderBreadcrumbs(sprintGroupId, true));
    }

    @GetMapping(value={"test-case/{testCaseId}"})
    Map<String, List<PathNodeDto>> getTestCasePathHeader(@PathVariable Long testCaseId) {
        return Collections.singletonMap(BREADCRUMBS, this.entityPathHeaderService.getTestCaseLibraryNodeHeaderBreadcrumbs(testCaseId));
    }

    @GetMapping(value={"test-case-folder/{testCaseFolderId}"})
    Map<String, List<PathNodeDto>> getTestCaseFolderPathHeader(@PathVariable Long testCaseFolderId) {
        return Collections.singletonMap(BREADCRUMBS, this.entityPathHeaderService.getTestCaseLibraryNodeHeaderBreadcrumbs(testCaseFolderId));
    }

    @GetMapping(value={"requirement/{requirementId}"})
    Map<String, List<PathNodeDto>> getRequirementPathHeader(@PathVariable Long requirementId) {
        return Collections.singletonMap(BREADCRUMBS, this.entityPathHeaderService.getRequirementLibraryNodeHeaderBreadcrumbs(requirementId));
    }

    @GetMapping(value={"requirement-folder/{requirementFolderId}"})
    Map<String, List<PathNodeDto>> getRequirementFolderPathHeader(@PathVariable Long requirementFolderId) {
        return Collections.singletonMap(BREADCRUMBS, this.entityPathHeaderService.getRequirementLibraryNodeHeaderBreadcrumbs(requirementFolderId));
    }
}

