/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.customreport;

import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.service.customreport.CustomReportFolderService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.internal.repository.CustomReportLibraryNodeDao;

@RestController
@RequestMapping(value={"backend/custom-report-folder/{customReportId}"})
public class CustomReportFolderModificationController {
    private final CustomReportLibraryNodeService customReportLibraryNodeService;
    private final CustomReportFolderService crfService;
    private final CustomReportLibraryNodeDao customReportLibraryNodeDao;

    public CustomReportFolderModificationController(CustomReportLibraryNodeService customReportLibraryNodeService, CustomReportFolderService crfService, CustomReportLibraryNodeDao customReportLibraryNodeDao) {
        this.customReportLibraryNodeService = customReportLibraryNodeService;
        this.crfService = crfService;
        this.customReportLibraryNodeDao = customReportLibraryNodeDao;
    }

    @PostMapping(value={"/name"})
    public void changeName(@PathVariable Long customReportId, @RequestBody CustomReportFolderPatch patch) {
        this.customReportLibraryNodeService.renameNode(customReportId, patch.getName());
    }

    @PostMapping(value={"/description"})
    public void changeDescription(@PathVariable Long customReportId, @RequestBody CustomReportFolderPatch patch) {
        CustomReportLibraryNode crln = (CustomReportLibraryNode)this.customReportLibraryNodeDao.getReferenceById((Object)customReportId);
        this.crfService.updateDescription(crln.getEntityId(), patch.getDescription());
    }

    static class CustomReportFolderPatch {
        private String name;
        private String description;

        CustomReportFolderPatch() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}

