/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.customfield;

import jakarta.validation.Valid;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldOption;
import org.squashtest.tm.exception.DomainException;
import org.squashtest.tm.service.customfield.CustomFieldManagerService;
import org.squashtest.tm.service.display.custom.field.CustomFieldDisplayService;
import org.squashtest.tm.service.internal.display.dto.CustomFieldDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.dto.CustomFieldFormModel;

@RestController
@RequestMapping(value={"/backend/custom-fields"})
public class CustomFieldsController {
    private static final String CUSTOM_FIELDS_URL = "/{customFieldIds}";
    private final CustomFieldDisplayService customFieldDisplayService;
    private final CustomFieldManagerService customFieldManagerService;

    public CustomFieldsController(CustomFieldDisplayService customFieldDisplayService, CustomFieldManagerService customFieldManagerService) {
        this.customFieldDisplayService = customFieldDisplayService;
        this.customFieldManagerService = customFieldManagerService;
    }

    @PostMapping
    public GridResponse getAllCustomFields(@RequestBody GridRequest request) {
        return this.customFieldDisplayService.findAll(request);
    }

    @GetMapping
    public Map<String, List<CustomFieldDto>> getAllNamedReferences() {
        return Collections.singletonMap("customFields", this.customFieldDisplayService.findAllWithPossibleValues());
    }

    @PostMapping(value={"/new"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public Map<String, Object> createCustomField(@RequestBody CustomFieldFormModel customFieldFormModel) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        CustomField customField = customFieldFormModel.getCustomField();
        this.customFieldManagerService.persist(customField);
        response.put("id", customField.getId());
        return response;
    }

    @PostMapping(value={"/{cufId}/label"})
    public void changeLabel(@PathVariable long cufId, @RequestBody CustomFieldPatch patch) {
        this.customFieldManagerService.changeLabel(cufId, patch.getLabel());
    }

    @PostMapping(value={"/{cufId}/name"})
    public void changeName(@PathVariable long cufId, @RequestBody CustomFieldPatch patch) {
        this.customFieldManagerService.changeName(cufId, patch.getName());
    }

    @PostMapping(value={"/{cufId}/code"})
    public void changeCode(@PathVariable long cufId, @RequestBody CustomFieldPatch patch) {
        this.customFieldManagerService.changeCode(cufId, patch.getCode());
    }

    @PostMapping(value={"/{cufId}/optional"})
    public void changeOptional(@PathVariable long cufId, @RequestBody CustomFieldPatch patch) {
        this.customFieldManagerService.changeOptional(Long.valueOf(cufId), patch.isOptional());
    }

    @PostMapping(value={"/{cufId}/default-value"})
    public void changeDefaultValue(@PathVariable long cufId, @RequestBody CustomFieldPatch patch) {
        this.customFieldManagerService.changeDefaultValue(cufId, patch.getDefaultValue());
    }

    @PostMapping(value={"/{cufId}/numeric-default-value"})
    public void changeNumericDefaultValue(@PathVariable long cufId, @RequestBody CustomFieldPatch patch) {
        Double value = patch.getNumericDefaultValue();
        this.customFieldManagerService.changeDefaultValue(cufId, value == null ? null : value.toString());
    }

    @PostMapping(value={"/{cufId}/large-default-value"})
    public void changeLargeDefaultValue(@PathVariable long cufId, @RequestBody CustomFieldPatch patch) {
        this.customFieldManagerService.changeDefaultValue(cufId, patch.getLargeDefaultValue());
    }

    @DeleteMapping(value={"/{customFieldIds}"})
    public void deleteCustomField(@PathVariable(value="customFieldIds") List<Long> customFieldIds) {
        this.customFieldManagerService.deleteCustomField(customFieldIds);
    }

    @PostMapping(value={"/{cufId}/options/new"})
    public CustomFieldDto addOption(@PathVariable long cufId, @Valid @RequestBody CustomFieldOption option) {
        try {
            this.customFieldManagerService.addOption(Long.valueOf(cufId), option);
        }
        catch (DomainException e) {
            e.setObjectName("new-cuf-option");
            throw e;
        }
        return this.customFieldDisplayService.getCustomFieldView(Long.valueOf(cufId));
    }

    @PostMapping(value={"/{cufId}/options/remove"})
    public void removeOption(@PathVariable long cufId, @RequestBody Map<String, List<String>> request) {
        this.customFieldManagerService.removeOptions(cufId, request.get("optionLabels"));
    }

    @PostMapping(value={"/{cufId}/options/label"})
    public void changeOptionLabel(@PathVariable long cufId, @RequestBody CustomFieldOptionPatch patch) {
        try {
            this.customFieldManagerService.changeOptionLabel(Long.valueOf(cufId), patch.getCurrentLabel(), patch.getNewLabel());
        }
        catch (DomainException e) {
            e.setObjectName("rename-cuf-option");
            throw e;
        }
    }

    @PostMapping(value={"/{cufId}/options/code"})
    public void changeOptionCode(@PathVariable long cufId, @RequestBody CustomFieldOptionPatch patch) {
        try {
            this.customFieldManagerService.changeOptionCode(cufId, patch.getCurrentLabel(), patch.getCode());
        }
        catch (DomainException e) {
            e.setObjectName("change-cuf-option-code");
            throw e;
        }
    }

    @PostMapping(value={"/{cufId}/options/color"})
    public void changeOptionColor(@PathVariable long cufId, @RequestBody CustomFieldOptionPatch patch) {
        try {
            this.customFieldManagerService.changeOptionColour(cufId, patch.getCurrentLabel(), patch.getColor());
        }
        catch (DomainException e) {
            e.setObjectName("change-cuf-option-colour");
            throw e;
        }
    }

    @PostMapping(value={"/{cufId}/options/positions"})
    public CustomFieldDto changeOptionsPositions(@PathVariable long cufId, @RequestBody ReorderOptionsRequestBody requestBody) {
        this.customFieldManagerService.changeOptionsPositions(cufId, requestBody.position.intValue(), requestBody.getLabels());
        return this.customFieldDisplayService.getCustomFieldView(Long.valueOf(cufId));
    }

    static class CustomFieldOptionPatch {
        private String currentLabel;
        private String newLabel;
        private String code;
        private String color;

        CustomFieldOptionPatch() {
        }

        public String getCurrentLabel() {
            return this.currentLabel;
        }

        public void setCurrentLabel(String currentLabel) {
            this.currentLabel = currentLabel;
        }

        public String getNewLabel() {
            return this.newLabel;
        }

        public void setNewLabel(String newLabel) {
            this.newLabel = newLabel;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getColor() {
            return this.color;
        }

        public void setColor(String color) {
            this.color = color;
        }
    }

    static class CustomFieldPatch {
        private String name;
        private String label;
        private String code;
        private boolean optional;
        private String defaultValue;
        private Double numericDefaultValue;
        private String largeDefaultValue;

        CustomFieldPatch() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public void setOptional(boolean optional) {
            this.optional = optional;
        }

        public Double getNumericDefaultValue() {
            return this.numericDefaultValue;
        }

        public void setNumericDefaultValue(Double numericDefaultValue) {
            this.numericDefaultValue = numericDefaultValue;
        }

        public String getLargeDefaultValue() {
            return this.largeDefaultValue;
        }

        public void setLargeDefaultValue(String largeDefaultValue) {
            this.largeDefaultValue = largeDefaultValue;
        }
    }

    static class ReorderOptionsRequestBody {
        private List<String> labels;
        private Integer position;

        ReorderOptionsRequestBody() {
        }

        public Integer getPosition() {
            return this.position;
        }

        public void setPosition(Integer position) {
            this.position = position;
        }

        public List<String> getLabels() {
            return this.labels;
        }

        public void setLabels(List<String> labels) {
            this.labels = labels;
        }
    }
}

