/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.campaign;

import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.service.campaign.CampaignTestPlanManagerService;
import org.squashtest.tm.service.campaign.ExecutionCreationService;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.display.campaign.TestPlanItemDisplayService;
import org.squashtest.tm.service.execution.ExecutionDeletionService;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.testplanitem.GenericTestPlanItemManager;
import org.squashtest.tm.service.testplanitem.SprintTestPlanItemManager;
import org.squashtest.tm.web.backend.controller.campaign.IterationTestPlanManagerController;

@RestController
@RequestMapping(value={"backend/test-plan-item"})
public class TestPlanItemController {
    private final GenericTestPlanItemManager genericTestPlanManagerService;
    private final IterationTestPlanManagerService iterationTestPlanManagerService;
    private final CampaignTestPlanManagerService campaignTestPlanManagerService;
    private final SprintTestPlanItemManager sprintTestPlanItemManager;
    private final ExecutionCreationService executionCreationService;
    private final TestPlanItemDisplayService testPlanItemDisplayService;
    private final ExecutionDeletionService executionDeletionService;

    public TestPlanItemController(GenericTestPlanItemManager genericTestPlanManagerService, IterationTestPlanManagerService iterationTestPlanManagerService, CampaignTestPlanManagerService campaignTestPlanManagerService, SprintTestPlanItemManager sprintTestPlanItemManager, ExecutionCreationService executionCreationService, TestPlanItemDisplayService testPlanItemDisplayService, ExecutionDeletionService executionDeletionService) {
        this.genericTestPlanManagerService = genericTestPlanManagerService;
        this.iterationTestPlanManagerService = iterationTestPlanManagerService;
        this.campaignTestPlanManagerService = campaignTestPlanManagerService;
        this.sprintTestPlanItemManager = sprintTestPlanItemManager;
        this.executionCreationService = executionCreationService;
        this.testPlanItemDisplayService = testPlanItemDisplayService;
        this.executionDeletionService = executionDeletionService;
    }

    @PostMapping(value={"{testPlanItemId}/dataset"})
    public Long changeDataset(@PathVariable long testPlanItemId, @RequestBody DatasetIdRecord patch) {
        this.genericTestPlanManagerService.changeDataset(testPlanItemId, patch.datasetId());
        return patch.datasetId();
    }

    @PostMapping(value={"campaign/{testPlanItemId}/dataset"})
    public Long setDatasetToCampaignTestPlanItem(@PathVariable long testPlanItemId, @RequestBody DatasetIdRecord patch) {
        this.campaignTestPlanManagerService.changeDataset(testPlanItemId, patch.datasetId());
        return patch.datasetId();
    }

    @PostMapping(value={"{testPlanItemId}/new-manual-execution"})
    public CreateExecutionResponse createExecution(@PathVariable long testPlanItemId) {
        Execution newExecution = this.executionCreationService.createManualExecution(testPlanItemId);
        return new CreateExecutionResponse(newExecution.getId());
    }

    @PostMapping(value={"{testPlanItemId}/executions"})
    public GridResponse getExecutions(@PathVariable long testPlanItemId, @RequestBody GridRequest gridRequest) {
        return this.testPlanItemDisplayService.getTestPlanItemExecutions(testPlanItemId, gridRequest);
    }

    @PostMapping(value={"/{testPlanItemIds}/assign-user"})
    public Long assignUserTestPlanItems(@PathVariable List<Long> testPlanItemIds, @RequestBody AssigneeRecord patch) {
        this.genericTestPlanManagerService.assignUserToTestPlanItems(testPlanItemIds, patch.assignee());
        return patch.assignee();
    }

    @PostMapping(value={"/{testPlanItemsIds}/execution-status"})
    public void updateIterationTestPlanItemsStatus(@PathVariable List<Long> testPlanItemsIds, @RequestBody IterationTestPlanManagerController.IterationTestPlanItemPatch patch) {
        this.iterationTestPlanManagerService.forceExecutionStatus(testPlanItemsIds, patch.getExecutionStatus());
    }

    @PostMapping(value={"/{testPlanItemIds}/status"})
    public void updateTestPlanItemsStatus(@PathVariable List<Long> testPlanItemIds, @RequestBody ExecutionStatusRecord requestBody) {
        this.sprintTestPlanItemManager.applyFastPass(testPlanItemIds, requestBody.executionStatus());
    }

    @PostMapping(value={"/{testPlanItemsIds}/assign-user-to-ctpi"})
    public Long assignUserToCampaignTestPlanItem(@PathVariable List<Long> testPlanItemsIds, @RequestBody AssigneeRecord patch) {
        this.campaignTestPlanManagerService.assignUserToTestPlanItems(testPlanItemsIds, patch.assignee);
        return patch.assignee;
    }

    @DeleteMapping(value={"/{testPlanItemId}/execution/{executionIds}"})
    public void deleteExecutions(@PathVariable long testPlanItemId, @PathVariable List<Long> executionIds) {
        this.executionDeletionService.deleteExecutions(executionIds);
    }

    public record AssigneeRecord(Long assignee) {
    }

    public record CreateExecutionResponse(Long executionId) {
    }

    public record DatasetIdRecord(Long datasetId) {
    }

    public record ExecutionStatusRecord(String executionStatus) {
    }
}

