/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.campaign;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignStatus;
import org.squashtest.tm.service.campaign.CampaignModificationService;
import org.squashtest.tm.service.campaign.CustomCampaignModificationService;
import org.squashtest.tm.service.campaign.IterationModificationService;
import org.squashtest.tm.service.display.campaign.CampaignDisplayService;
import org.squashtest.tm.service.internal.display.dto.campaign.IterationPlanningDto;

@RestController
@RequestMapping(value={"backend/campaign/{campaignId}"})
public class CampaignViewModificationController {
    private final CustomCampaignModificationService customCampaignModificationService;
    private final CampaignModificationService campaignModificationService;
    private final IterationModificationService iterationModificationService;
    private final CampaignDisplayService campaignDisplayService;

    public CampaignViewModificationController(CustomCampaignModificationService customCampaignModificationService, CampaignModificationService campaignModificationService, IterationModificationService iterationModificationService, CampaignDisplayService campaignDisplayService) {
        this.customCampaignModificationService = customCampaignModificationService;
        this.campaignModificationService = campaignModificationService;
        this.iterationModificationService = iterationModificationService;
        this.campaignDisplayService = campaignDisplayService;
    }

    @PostMapping(value={"/name"})
    public void rename(@PathVariable Long campaignId, @RequestBody CampaignPatch patch) {
        this.customCampaignModificationService.rename(campaignId.longValue(), patch.getName());
    }

    @PostMapping(value={"/reference"})
    public void changeReference(@PathVariable Long campaignId, @RequestBody CampaignPatch patch) {
        this.campaignModificationService.changeReference(campaignId.longValue(), patch.getReference());
    }

    @PostMapping(value={"/description"})
    public void changeDescription(@PathVariable Long campaignId, @RequestBody CampaignPatch patch) {
        this.campaignModificationService.changeDescription(campaignId.longValue(), patch.getDescription());
    }

    @PostMapping(value={"/campaign-status"})
    public void changeCampaignStatus(@PathVariable Long campaignId, @RequestBody CampaignPatch patch) {
        this.campaignModificationService.changeStatus(campaignId.longValue(), CampaignStatus.valueOf((String)patch.getCampaignStatus()));
    }

    @PostMapping(value={"/milestone/{milestoneId}"})
    public void bindMilestone(@PathVariable Long campaignId, @PathVariable Long milestoneId) {
        this.campaignModificationService.bindMilestone(campaignId.longValue(), milestoneId.longValue());
    }

    @DeleteMapping(value={"/milestone"})
    public void unbindMilestones(@PathVariable Long campaignId, @RequestBody List<Long> milestoneIds) {
        this.campaignModificationService.unbindMilestones(campaignId.longValue(), milestoneIds);
    }

    @DeleteMapping(value={"/milestone/{milestoneId}"})
    public void unbindSingleMilestone(@PathVariable Long campaignId, @PathVariable Long milestoneId) {
        this.campaignModificationService.unbindSingleMilestone(campaignId.longValue(), milestoneId);
    }

    @PostMapping(value={"/scheduled-start-date"})
    public void setScheduledStart(@PathVariable long campaignId, @RequestBody CampaignPatch campaignPatch) {
        this.campaignModificationService.changeScheduledStartDate(campaignId, campaignPatch.getScheduledStartDate());
    }

    @PostMapping(value={"/scheduled-end-date"})
    public void setScheduledEnd(@PathVariable long campaignId, @RequestBody CampaignPatch campaignPatch) {
        this.campaignModificationService.changeScheduledEndDate(campaignId, campaignPatch.getScheduledEndDate());
    }

    @PostMapping(value={"/actual-start-date"})
    public void setActualStart(@PathVariable long campaignId, @RequestBody CampaignPatch campaignPatch) {
        this.campaignModificationService.changeActualStartDate(campaignId, campaignPatch.getActualStartDate());
    }

    @PostMapping(value={"/actual-end-date"})
    public void setActualEnd(@PathVariable long campaignId, @RequestBody CampaignPatch campaignPatch) {
        this.campaignModificationService.changeActualEndDate(campaignId, campaignPatch.getActualEndDate());
    }

    @PostMapping(value={"/actual-start-auto"})
    public Date setActualStartAuto(@PathVariable long campaignId, @RequestBody CampaignPatch campaignPatch) {
        this.campaignModificationService.changeActualStartAuto(campaignId, campaignPatch.getActualStartAuto().booleanValue());
        Campaign campaign = this.campaignModificationService.findById(campaignId);
        return campaign.getActualStartDate();
    }

    @PostMapping(value={"/actual-end-auto"})
    public Date setActualEndAuto(@PathVariable long campaignId, @RequestBody CampaignPatch campaignPatch) {
        this.campaignModificationService.changeActualEndAuto(campaignId, campaignPatch.getActualEndAuto().booleanValue());
        Campaign campaign = this.campaignModificationService.findById(campaignId);
        return campaign.getActualEndDate();
    }

    @GetMapping(value={"/iterations"})
    public List<IterationPlanningDto> getIterations(@PathVariable long campaignId) {
        return this.campaignDisplayService.findIterationsPlanningByCampaign(Long.valueOf(campaignId));
    }

    @PostMapping(value={"/iterations/planning"})
    public void setIterationsPlanning(@RequestBody IterationPlanningPatch patch) {
        for (IterationPlanningDto iter : patch.iterationPlannings) {
            this.iterationModificationService.changeScheduledStartDate(iter.getId().longValue(), iter.getScheduledStartDate());
            this.iterationModificationService.changeScheduledEndDate(iter.getId().longValue(), iter.getScheduledEndDate());
        }
    }

    static class CampaignPatch {
        private String name;
        private String reference;
        private String description;
        private String campaignStatus;
        private Date scheduledEndDate;
        private Date scheduledStartDate;
        private Date actualEndDate;
        private Date actualStartDate;
        private Boolean actualEndAuto;
        private Boolean actualStartAuto;

        CampaignPatch() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getReference() {
            return this.reference;
        }

        public void setReference(String reference) {
            this.reference = reference;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Date getScheduledEndDate() {
            return this.scheduledEndDate;
        }

        public void setScheduledEndDate(Date scheduledEndDate) {
            this.scheduledEndDate = scheduledEndDate;
        }

        public Date getScheduledStartDate() {
            return this.scheduledStartDate;
        }

        public void setScheduledStartDate(Date scheduledStartDate) {
            this.scheduledStartDate = scheduledStartDate;
        }

        public Date getActualEndDate() {
            return this.actualEndDate;
        }

        public void setActualEndDate(Date actualEndDate) {
            this.actualEndDate = actualEndDate;
        }

        public Date getActualStartDate() {
            return this.actualStartDate;
        }

        public void setActualStartDate(Date actualStartDate) {
            this.actualStartDate = actualStartDate;
        }

        public Boolean getActualEndAuto() {
            return this.actualEndAuto;
        }

        public void setActualEndAuto(Boolean actualEndAuto) {
            this.actualEndAuto = actualEndAuto;
        }

        public Boolean getActualStartAuto() {
            return this.actualStartAuto;
        }

        public void setActualStartAuto(Boolean actualStartAuto) {
            this.actualStartAuto = actualStartAuto;
        }

        public String getCampaignStatus() {
            return this.campaignStatus;
        }

        public void setCampaignStatus(String campaignStatus) {
            this.campaignStatus = campaignStatus;
        }
    }

    static class IterationPlanningPatch {
        List<IterationPlanningDto> iterationPlannings = new ArrayList<IterationPlanningDto>();

        IterationPlanningPatch() {
        }

        public List<IterationPlanningDto> getIterationPlannings() {
            return this.iterationPlannings;
        }

        public void setIterationPlannings(List<IterationPlanningDto> iterationPlannings) {
            this.iterationPlannings = iterationPlannings;
        }
    }
}

