/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.campaign;

import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.QuoteMode;
import org.springframework.context.MessageSource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.NodeWorkspace;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintGroup;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.export.CampaignExportCSVModel;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.exception.library.RightsUnsuficientsForOperationException;
import org.squashtest.tm.service.campaign.CampaignFinder;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.campaign.IterationModificationService;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.deletion.CampaignLibraryNodesToDelete;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.display.workspace.tree.MultipleHierarchyTreeBrowser;
import org.squashtest.tm.service.display.workspace.tree.TreeBrowser;
import org.squashtest.tm.service.display.workspace.tree.TreeNodeCollectorService;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.display.grid.TreeGridResponse;
import org.squashtest.tm.service.internal.display.grid.TreeRequest;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;
import org.squashtest.tm.web.backend.controller.form.model.CampaignFolderFormModel;
import org.squashtest.tm.web.backend.controller.form.model.CampaignFormModel;
import org.squashtest.tm.web.backend.controller.form.model.EntityFormModel;
import org.squashtest.tm.web.backend.controller.form.model.EntityFormModelValidator;
import org.squashtest.tm.web.backend.controller.form.model.IterationFormModel;
import org.squashtest.tm.web.backend.controller.form.model.NodeList;
import org.squashtest.tm.web.backend.controller.form.model.NodeListAndWhiteList;
import org.squashtest.tm.web.backend.controller.form.model.RefreshTreeNodeModel;
import org.squashtest.tm.web.backend.controller.form.model.SprintFormModel;
import org.squashtest.tm.web.backend.controller.form.model.SprintGroupFormModel;
import org.squashtest.tm.web.backend.controller.form.model.TestSuiteFormModel;
import org.squashtest.tm.web.backend.controller.navigation.Messages;

@RestController
@RequestMapping(path={"backend/campaign-tree"})
public class CampaignLibraryNavigationController {
    public static final Logger LOGGER = LoggerFactory.getLogger(CampaignLibraryNavigationController.class);
    private static final String ADD_CAMPAIGN = "add-campaign";
    private static final String ADD_SPRINT = "add-sprint";
    private static final String ADD_SPRINT_GROUP = "add-sprint-group";
    private static final String ADD_ITERATION = "add-iteration";
    private static final String ADD_CAMPAIGN_FOLDER = "add-campaign-folder";
    private static final String REMOVE_FROM_ITER = "remove_from_iter";
    private static final String ENTITY_TYPE_IS_NOT_HANDLED = "This entity type is not handled ";
    private final TreeBrowser treeBrowser;
    private final CampaignLibraryNavigationService campaignLibraryNavigationService;
    private final TreeNodeCollectorService treeNodeCollectorService;
    private final IterationModificationService iterationModificationService;
    private final MessageSource messageSource;
    private final CampaignFinder campaignFinder;

    public CampaignLibraryNavigationController(MultipleHierarchyTreeBrowser treeBrowser, CampaignLibraryNavigationService campaignLibraryNavigationService, TreeNodeCollectorService treeNodeCollectorService, IterationModificationService iterationModificationService, MessageSource messageSource, CampaignFinder campaignFinder) {
        this.treeBrowser = treeBrowser;
        this.campaignLibraryNavigationService = campaignLibraryNavigationService;
        this.treeNodeCollectorService = treeNodeCollectorService;
        this.iterationModificationService = iterationModificationService;
        this.messageSource = messageSource;
        this.campaignFinder = campaignFinder;
    }

    @PostMapping
    public TreeGridResponse getInitialRows(@RequestBody TreeRequest treeRequest) {
        return this.treeBrowser.getInitialTree(NodeWorkspace.CAMPAIGN, NodeReference.fromNodeIds((Collection)treeRequest.getOpenedNodes()), NodeReference.fromNodeIds((Collection)treeRequest.getSelectedNodes()));
    }

    @GetMapping(value={"/{ids}/content"})
    public TreeGridResponse getChildren(@PathVariable List<String> ids) {
        Set nodeReference = NodeReference.fromNodeIds(ids);
        return this.treeBrowser.findSubHierarchy(nodeReference, new HashSet(nodeReference));
    }

    @PostMapping(value={"/refresh"})
    public TreeGridResponse refreshNodes(@RequestBody RefreshTreeNodeModel refreshTreeNodeModel) {
        return this.treeBrowser.findSubHierarchy(NodeReference.fromNodeIds(refreshTreeNodeModel.getNodeIds()), new HashSet<NodeReference>(refreshTreeNodeModel.getNodeList().getNodeReferences()));
    }

    @PostMapping(value={"new-campaign"})
    public DataRow addNewCampaign(@RequestBody CampaignFormModel campaignFormModel) throws BindException {
        this.validateFormModel(campaignFormModel, ADD_CAMPAIGN);
        Campaign campaign = campaignFormModel.getCampaign();
        campaign.setActualStartAuto(true);
        campaign.setActualEndAuto(true);
        Map<Long, RawValue> customFieldValues = campaignFormModel.getCufs();
        String serializedParentEntityReference = campaignFormModel.getParentEntityReference();
        EntityReference parentEntityReference = EntityReference.fromNodeId((String)serializedParentEntityReference);
        switch (parentEntityReference.getType()) {
            case CAMPAIGN_LIBRARY: {
                this.campaignLibraryNavigationService.addCampaignToCampaignLibrary(parentEntityReference.getId().longValue(), campaign, customFieldValues);
                break;
            }
            case CAMPAIGN_FOLDER: {
                this.campaignLibraryNavigationService.addCampaignToCampaignFolder(parentEntityReference.getId().longValue(), campaign, customFieldValues);
                break;
            }
            default: {
                throw new IllegalArgumentException(ENTITY_TYPE_IS_NOT_HANDLED + serializedParentEntityReference);
            }
        }
        return this.treeNodeCollectorService.collectNode(NodeType.CAMPAIGN, (Identified)campaign);
    }

    @PostMapping(value={"new-sprint"})
    public DataRow addNewSprint(@RequestBody SprintFormModel sprintFormModel) throws BindException {
        this.validateFormModel(sprintFormModel, ADD_SPRINT);
        Sprint sprint = sprintFormModel.getSprint();
        Map<Long, RawValue> customFieldValues = sprintFormModel.getCufs();
        String serializedParentEntityReference = sprintFormModel.getParentEntityReference();
        EntityReference parentEntityReference = EntityReference.fromNodeId((String)serializedParentEntityReference);
        switch (parentEntityReference.getType()) {
            case CAMPAIGN_LIBRARY: {
                this.campaignLibraryNavigationService.addSprintToCampaignLibrary(parentEntityReference.getId().longValue(), sprint, customFieldValues);
                break;
            }
            case CAMPAIGN_FOLDER: {
                this.campaignLibraryNavigationService.addSprintToCampaignFolder(parentEntityReference.getId().longValue(), sprint, customFieldValues);
                break;
            }
            case SPRINT_GROUP: {
                this.campaignLibraryNavigationService.addSprintToSprintGroup(parentEntityReference.getId().longValue(), sprint, customFieldValues);
                break;
            }
            default: {
                throw new IllegalArgumentException(ENTITY_TYPE_IS_NOT_HANDLED + serializedParentEntityReference);
            }
        }
        return this.treeNodeCollectorService.collectNode(NodeType.SPRINT, (Identified)sprint);
    }

    @PostMapping(value={"new-sprint-group"})
    public DataRow addNewSprintGroup(@RequestBody SprintGroupFormModel sprintGroupFormModel) throws BindException {
        this.validateFormModel(sprintGroupFormModel, ADD_SPRINT_GROUP);
        SprintGroup sprintGroup = sprintGroupFormModel.getSprintGroup();
        Map<Long, RawValue> customFieldValues = sprintGroupFormModel.getCufs();
        String serializedParentEntityReference = sprintGroupFormModel.getParentEntityReference();
        EntityReference parentEntityReference = EntityReference.fromNodeId((String)serializedParentEntityReference);
        switch (parentEntityReference.getType()) {
            case CAMPAIGN_LIBRARY: {
                this.campaignLibraryNavigationService.addSprintGroupToCampaignLibrary(parentEntityReference.getId().longValue(), sprintGroup, customFieldValues);
                break;
            }
            case CAMPAIGN_FOLDER: {
                this.campaignLibraryNavigationService.addSprintGroupToCampaignFolder(parentEntityReference.getId().longValue(), sprintGroup, customFieldValues);
                break;
            }
            default: {
                throw new IllegalArgumentException(ENTITY_TYPE_IS_NOT_HANDLED + serializedParentEntityReference);
            }
        }
        return this.treeNodeCollectorService.collectNode(NodeType.SPRINT_GROUP, (Identified)sprintGroup);
    }

    @PostMapping(value={"campaign/{campaignId}/new-iteration"})
    public DataRow addNewIterationToCampaign(@PathVariable long campaignId, @RequestBody IterationFormModel iterationForm) throws BindException {
        this.validateFormModel(iterationForm, ADD_ITERATION);
        Iteration newIteration = iterationForm.getIteration();
        Map<Long, RawValue> customFieldValues = iterationForm.getCufs();
        boolean copyTestPlan = iterationForm.isCopyTestPlan();
        this.iterationModificationService.addIterationToCampaign(newIteration, campaignId, copyTestPlan, customFieldValues);
        return this.treeNodeCollectorService.collectNode(NodeType.ITERATION, (Identified)newIteration);
    }

    @PostMapping(value={"new-folder"})
    public DataRow addNewFolder(@RequestBody CampaignFolderFormModel folderModel) throws BindException {
        this.validateCampaignFolderFormModel(folderModel);
        CampaignFolder campaignFolder = folderModel.getCampaignFolder();
        Map<Long, RawValue> customFieldValues = folderModel.getCufs();
        String serializedParentEntityReference = folderModel.getParentEntityReference();
        EntityReference parentEntityReference = EntityReference.fromNodeId((String)serializedParentEntityReference);
        switch (parentEntityReference.getType()) {
            case CAMPAIGN_LIBRARY: {
                this.campaignLibraryNavigationService.addFolderToLibrary(parentEntityReference.getId().longValue(), (Folder)campaignFolder, customFieldValues);
                break;
            }
            case CAMPAIGN_FOLDER: {
                this.campaignLibraryNavigationService.addFolderToFolder(parentEntityReference.getId().longValue(), (Folder)campaignFolder, customFieldValues);
                break;
            }
            case SPRINT_GROUP: {
                this.campaignLibraryNavigationService.addFolderToSprintGroup(parentEntityReference.getId().longValue(), campaignFolder, customFieldValues);
                break;
            }
            default: {
                throw new IllegalArgumentException(ENTITY_TYPE_IS_NOT_HANDLED + serializedParentEntityReference);
            }
        }
        return this.treeNodeCollectorService.collectNode(NodeType.CAMPAIGN_FOLDER, (Identified)campaignFolder);
    }

    @PostMapping(value={"new-test-suite"})
    public DataRow addTestSuite(@RequestBody TestSuiteFormModel suiteFormModel) {
        TestSuite suite = suiteFormModel.getTestSuite();
        Map<Long, RawValue> customFieldValues = suiteFormModel.getCufs();
        String serializedParentEntityReference = suiteFormModel.getParentEntityReference();
        EntityReference parentEntityReference = EntityReference.fromNodeId((String)serializedParentEntityReference);
        this.campaignLibraryNavigationService.addTestSuiteToIteration(parentEntityReference.getId(), suite, customFieldValues);
        return this.treeNodeCollectorService.collectNode(NodeType.TEST_SUITE, (Identified)suite);
    }

    @PostMapping(value={"/{destinationId}/content/paste"})
    public void pasteNodes(@RequestBody NodeListAndWhiteList nodeListAndWhiteList, @PathVariable(value="destinationId") String destinationId) {
        NodeReference nodeReference = NodeReference.fromNodeId((String)destinationId);
        List<Long> copiedNodeIds = nodeListAndWhiteList.getIds();
        ClipboardPayload clipboardPayload = nodeListAndWhiteList.asClipboardPayload();
        try {
            switch (nodeReference.getNodeType()) {
                case CAMPAIGN_FOLDER: {
                    this.campaignLibraryNavigationService.copyNodesToFolder(nodeReference.getId().longValue(), copiedNodeIds.toArray(new Long[0]), clipboardPayload);
                    break;
                }
                case CAMPAIGN_LIBRARY: {
                    this.campaignLibraryNavigationService.copyNodesToLibrary(nodeReference.getId().longValue(), copiedNodeIds.toArray(new Long[0]), clipboardPayload);
                    break;
                }
                case CAMPAIGN: {
                    this.campaignLibraryNavigationService.copyIterationsToCampaign(nodeReference.getId().longValue(), copiedNodeIds.toArray(new Long[0]), clipboardPayload);
                    break;
                }
                case SPRINT_GROUP: {
                    this.campaignLibraryNavigationService.copyNodesToSprintGroup(nodeReference.getId().longValue(), copiedNodeIds.toArray(new Long[0]), clipboardPayload);
                    break;
                }
                case ITERATION: {
                    this.iterationModificationService.copyPasteTestSuitesToIteration(copiedNodeIds.toArray(new Long[0]), nodeReference.getId().longValue(), clipboardPayload);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("copy nodes : specified destination type doesn't exists : " + String.valueOf(nodeReference.getNodeType()));
                }
            }
        }
        catch (AccessDeniedException ade) {
            throw new RightsUnsuficientsForOperationException((Exception)((Object)ade));
        }
    }

    @PostMapping(value={"/{destinationRef}/content/move"})
    public void moveNodes(@RequestBody NodeList nodeList, @PathVariable(value="destinationRef") String destinationRef) {
        NodeReference nodeReference = NodeReference.fromNodeId((String)destinationRef);
        Long destinationId = nodeReference.getId();
        NodeType destinationType = nodeReference.getNodeType();
        Long[] movedNodeIds = nodeList.getIds().toArray(new Long[0]);
        ClipboardPayload clipboardPayload = ClipboardPayload.withWhiteListIgnored(nodeList.getIds());
        try {
            switch (destinationType) {
                case CAMPAIGN_LIBRARY: {
                    this.campaignLibraryNavigationService.moveNodesToLibrary(destinationId.longValue(), movedNodeIds, clipboardPayload);
                    break;
                }
                case CAMPAIGN_FOLDER: {
                    this.campaignLibraryNavigationService.moveNodesToFolder(destinationId.longValue(), movedNodeIds, clipboardPayload);
                    break;
                }
                case SPRINT_GROUP: {
                    this.campaignLibraryNavigationService.moveNodesToSprintGroup(destinationId, movedNodeIds, clipboardPayload);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("move nodes : specified destination type doesn't exists : " + String.valueOf(destinationType));
                }
            }
        }
        catch (AccessDeniedException ade) {
            throw new RightsUnsuficientsForOperationException((Exception)((Object)ade));
        }
    }

    @PostMapping(value={"/{destinationRef}/content/move/{position}"})
    public void moveNodesAtPosition(@RequestBody NodeList nodeList, @PathVariable(value="destinationRef") String destinationRef, @PathVariable(value="position") int position) {
        NodeReference nodeReference = NodeReference.fromNodeId((String)destinationRef);
        Long destinationId = nodeReference.getId();
        NodeType destinationType = nodeReference.getNodeType();
        Long[] movedNodeIds = nodeList.getIds().toArray(new Long[0]);
        ClipboardPayload clipboardPayload = ClipboardPayload.withWhiteListIgnored(nodeList.getIds());
        try {
            switch (destinationType) {
                case CAMPAIGN_LIBRARY: {
                    this.campaignLibraryNavigationService.moveNodesToLibrary(destinationId.longValue(), movedNodeIds, position, clipboardPayload);
                    break;
                }
                case CAMPAIGN_FOLDER: {
                    this.campaignLibraryNavigationService.moveNodesToFolder(destinationId.longValue(), movedNodeIds, position, clipboardPayload);
                    break;
                }
                case CAMPAIGN: {
                    this.campaignLibraryNavigationService.moveIterationsWithinCampaign(destinationId.longValue(), movedNodeIds, position);
                    break;
                }
                case ITERATION: {
                    this.iterationModificationService.changeTestSuitePosition(destinationId.longValue(), position, nodeList.getIds());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("move nodes : specified destination type doesn't exists : " + String.valueOf(destinationType));
                }
            }
        }
        catch (AccessDeniedException ade) {
            throw new RightsUnsuficientsForOperationException((Exception)((Object)ade));
        }
    }

    @GetMapping(value={"/deletion-simulation/{nodeIds}"})
    public Messages simulateNodesDeletion(@PathVariable(value="nodeIds") List<String> nodeIds, Locale locale) {
        CampaignLibraryNodesToDelete deletionNodes = CampaignLibraryNodesToDelete.from(nodeIds);
        List campaignLibraryNodeIdsToDelete = deletionNodes.getCampaignLibraryNodeIds();
        Messages messages = new Messages();
        if (!campaignLibraryNodeIdsToDelete.isEmpty()) {
            List reportList = this.campaignLibraryNavigationService.simulateDeletion(campaignLibraryNodeIdsToDelete);
            messages.addMessages(reportList, this.messageSource, locale);
        }
        List reportIterationList = this.campaignLibraryNavigationService.simulateIterationDeletion(deletionNodes.getIterationIds());
        messages.addMessages(reportIterationList, this.messageSource, locale);
        List reportSuiteList = this.campaignLibraryNavigationService.simulateSuiteDeletion(deletionNodes.getSuiteIds());
        messages.addMessages(reportSuiteList, this.messageSource, locale);
        return messages;
    }

    @DeleteMapping(value={"/{nodeIds}"}, params={"remove_from_iter"})
    public OperationReport confirmNodeDeletions(@PathVariable(value="nodeIds") List<String> nodeIds, @RequestParam(value="remove_from_iter") boolean removeFromIter) {
        CampaignLibraryNodesToDelete deletionNodes = CampaignLibraryNodesToDelete.from(nodeIds);
        return this.campaignLibraryNavigationService.deleteNodes(deletionNodes, removeFromIter);
    }

    @PostMapping(value={"campaign/{campaignId}/new-iteration-with-items"})
    public void addIterationToCampaignWithItems(@PathVariable long campaignId, @RequestBody IterationCreation patch) {
        this.iterationModificationService.createIterationWithItemCopies(campaignId, patch.name(), patch.description(), patch.itemTestPlanIds());
    }

    @GetMapping(value={"/export-campaign/{campaignId}"}, params={"export=csv"})
    public FileSystemResource exportCampaign(@PathVariable(value="campaignId") long campaignId, @RequestParam(value="exportType", defaultValue="S") String exportType, HttpServletResponse response) {
        Campaign campaign = this.campaignFinder.findById(campaignId);
        CampaignExportCSVModel model = this.campaignLibraryNavigationService.exportCampaignToCSV(Long.valueOf(campaignId), exportType);
        String fileName = CampaignLibraryNavigationController.buildFileName(exportType, campaign);
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        File exported = this.exportToFile(model);
        return new FileSystemResource(exported);
    }

    private static String buildFileName(String exportType, Campaign campaign) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String encodedCampaignName = URLEncoder.encode(campaign.getName(), StandardCharsets.UTF_8);
        return String.format("EXPORT_CPG_%s_%s_%s.csv", exportType, encodedCampaignName.replace(" ", "_"), sdf.format(new Date()));
    }

    private void validateCampaignFolderFormModel(CampaignFolderFormModel folderModel) throws BindException {
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)folderModel, ADD_CAMPAIGN_FOLDER);
        EntityFormModelValidator entityFormModelValidator = new EntityFormModelValidator();
        entityFormModelValidator.validate(folderModel, (Errors)validation);
        if (validation.hasErrors()) {
            throw new BindException((BindingResult)validation);
        }
    }

    private void validateFormModel(EntityFormModel formModel, String objectName) throws BindException {
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)formModel, objectName);
        EntityFormModelValidator validator = new EntityFormModelValidator();
        validator.validate(formModel, (Errors)validation);
        if (validation.hasErrors()) {
            throw new BindException((BindingResult)validation);
        }
    }

    private File exportToFile(CampaignExportCSVModel model) {
        try {
            File file = File.createTempFile("export-requirement", "tmp");
            file.deleteOnExit();
            return this.writeModel(model, file);
        }
        catch (IOException e) {
            throw new ActionException("campaign export : I/O failure while creating the temporary file", (Throwable)e);
        }
    }

    private File writeModel(CampaignExportCSVModel model, File file) throws IOException {
        CSVFormat csvFormat = CSVFormat.DEFAULT.builder().setQuoteMode(QuoteMode.ALL).build();
        Throwable throwable = null;
        Object var5_6 = null;
        try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)new FileWriter(file), csvFormat);){
            CampaignExportCSVModel.Row header = model.getHeader();
            csvPrinter.printRecord(this.getCleanCellsAsList(header));
            Iterator iterator = model.dataIterator();
            while (iterator.hasNext()) {
                CampaignExportCSVModel.Row datarow = (CampaignExportCSVModel.Row)iterator.next();
                csvPrinter.printRecord(this.getCleanCellsAsList(datarow));
            }
            return file;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private List<String> getCleanCellsAsList(CampaignExportCSVModel.Row row) {
        List<String> cells = row.getCells().stream().map(CampaignExportCSVModel.Cell::getValue).toList();
        cells.forEach(HTMLCleanupUtils::cleanHtml);
        return cells;
    }

    public record IterationCreation(String name, String description, List<Long> itemTestPlanIds) {
    }
}

