/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.bugtracker;

import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.service.project.GenericProjectManagerService;

@RestController
@RequestMapping(value={"/backend/issues/projects/{projectId}/bugtracker"})
public class BugTrackerInfoController {
    private final GenericProjectManagerService projectManager;

    public BugTrackerInfoController(GenericProjectManagerService projectManager) {
        this.projectManager = projectManager;
    }

    @GetMapping
    BugTrackerInfo getBugtrackerInfo(@PathVariable long projectId) {
        GenericProject project = this.projectManager.findById(projectId);
        BugTrackerInfo response = new BugTrackerInfo();
        if (project.isBoundToBugtracker()) {
            response.setProjectNames(project.getBugtrackerProjectNames());
            response.setKind(project.getBugTracker().getKind());
            response.setBugTrackerName(project.getBugTracker().getName());
        }
        return response;
    }

    public static class BugTrackerInfo {
        List<String> projectNames;
        String kind;
        String bugTrackerName;

        public List<String> getProjectNames() {
            return this.projectNames;
        }

        public void setProjectNames(List<String> projectNames) {
            this.projectNames = projectNames;
        }

        public String getKind() {
            return this.kind;
        }

        public void setKind(String kind) {
            this.kind = kind;
        }

        public String getBugTrackerName() {
            return this.bugTrackerName;
        }

        public void setBugTrackerName(String bugTrackerName) {
            this.bugTrackerName = bugTrackerName;
        }
    }
}

