/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.attachment;

import jakarta.inject.Inject;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.MessageSource;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.attachment.RawAttachment;
import org.squashtest.tm.service.attachment.UploadedData;
import org.squashtest.tm.service.display.attachment.AttachmentDisplayService;
import org.squashtest.tm.service.internal.display.dto.AttachmentDto;
import org.squashtest.tm.service.internal.display.dto.AttachmentListDto;
import org.squashtest.tm.web.backend.controller.attachment.UploadedDataPropertyEditorSupport;
import org.squashtest.tm.web.backend.fileupload.UploadContentFilterUtil;
import org.squashtest.tm.web.backend.fileupload.UploadSummary;

@RestController
@RequestMapping(value={"backend/attach-list/{attachListId}"})
public class AttachmentViewController {
    private static final String STR_UPLOAD_STATUS_OK = "dialog.attachment.summary.statusok.label";
    private static final String STR_UPLOAD_STATUS_WRONGFILETYPE = "dialog.attachment.summary.statuswrongtype.label";
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentViewController.class);
    @Inject
    private AttachmentManagerService attachmentManagerService;
    @Inject
    private AttachmentDisplayService attachmentDisplayService;
    @Inject
    private MessageSource messageSource;
    @Inject
    private UploadContentFilterUtil filterUtil;

    @InitBinder
    public void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) {
        binder.registerCustomEditor(UploadedData.class, (PropertyEditor)new UploadedDataPropertyEditorSupport());
    }

    @GetMapping
    public AttachmentListDto getAttachmentList(@PathVariable long attachListId) {
        return this.attachmentDisplayService.getAttachmentList(attachListId);
    }

    @DeleteMapping(value={"/attachments/{attachmentIds}"})
    public void removeAttachment(@PathVariable long attachListId, @PathVariable(value="attachmentIds") List<Long> attachmentIds, @RequestParam(value="entityId") long entityId, @RequestParam(value="entityType") String entityType, @RequestParam(value="holderType") String holderTypeName, HttpServletResponse response) throws IOException {
        EntityReference entityRef = this.getEntityReference(entityType, entityId);
        EntityType holderType = this.getEntityType(holderTypeName);
        try {
            this.attachmentManagerService.removeListOfAttachments(attachListId, attachmentIds, entityRef, holderType);
        }
        catch (IllegalArgumentException | AccessDeniedException e) {
            LOGGER.warn("Error happened during attachment deletion", e);
            response.setStatus(404);
        }
    }

    @PostMapping(value={"/attachments/upload"}, produces={"application/json"})
    public List<UploadSummary> uploadAttachmentAsJson(@RequestParam(value="attachment[]") List<UploadedData> attachments, @PathVariable long attachListId, @RequestParam(value="entityId") long entityId, @RequestParam(value="entityType") String entityType, @RequestParam(value="holderType") String holderTypeName, Locale locale) throws IOException {
        LinkedList<UploadSummary> summary = new LinkedList<UploadSummary>();
        EntityReference entityRef = this.getEntityReference(entityType, entityId);
        EntityType holderType = this.getEntityType(holderTypeName);
        for (UploadedData upload : attachments) {
            LOGGER.trace("Adding attachment {}", new Object[]{upload.getName()});
            boolean shouldProceed = this.filterUtil.isTypeAllowed(upload);
            if (!shouldProceed) {
                AttachmentDto refusedAttachmentDto = new AttachmentDto();
                refusedAttachmentDto.setName(HtmlUtils.htmlEscape((String)upload.getName()));
                summary.add(new UploadSummary(refusedAttachmentDto, this.getUploadSummary(STR_UPLOAD_STATUS_WRONGFILETYPE, locale), 1));
                continue;
            }
            AttachmentDto newAttachmentDto = this.attachmentManagerService.addAttachment(attachListId, (RawAttachment)upload, entityRef, holderType);
            summary.add(new UploadSummary(newAttachmentDto, this.getUploadSummary(STR_UPLOAD_STATUS_OK, locale), 0));
        }
        return summary;
    }

    @PostMapping(value={"/attachment/upload-image"}, produces={"application/json"})
    public List<UploadSummary> uploadImageFile(@RequestParam(value="attachment") UploadedData uploaded, @PathVariable long attachListId, @RequestParam(value="entityId") long entityId, @RequestParam(value="entityType") String entityType, @RequestParam(value="holderType") String holderTypeName, Locale locale) throws IOException {
        EntityReference entityRef = this.getEntityReference(entityType, entityId);
        EntityType holderType = this.getEntityType(holderTypeName);
        LOGGER.trace("Adding image attachment {}", new Object[]{uploaded.getName()});
        boolean shouldProceed = this.filterUtil.isImageType(uploaded);
        if (!shouldProceed) {
            AttachmentDto refusedAttachmentDto = new AttachmentDto();
            refusedAttachmentDto.setName(HtmlUtils.htmlEscape((String)uploaded.getName()));
            return Collections.singletonList(new UploadSummary(refusedAttachmentDto, this.getUploadSummary(STR_UPLOAD_STATUS_WRONGFILETYPE, locale), 1));
        }
        AttachmentDto newAttachmentDto = this.attachmentManagerService.addAttachment(attachListId, (RawAttachment)uploaded, entityRef, holderType);
        return Collections.singletonList(new UploadSummary(newAttachmentDto, this.getUploadSummary(STR_UPLOAD_STATUS_OK, locale), 0));
    }

    @GetMapping(value={"/attachments/download/{attachemendId}"})
    public void downloadAttachment(@PathVariable(value="attachemendId") long attachmentId, HttpServletResponse response) {
        try {
            Attachment attachment = this.attachmentManagerService.findAttachment(Long.valueOf(attachmentId));
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment; filename=\"" + attachment.getName().replace(" ", "_") + "\"");
            ServletOutputStream outStream = response.getOutputStream();
            this.attachmentManagerService.writeContent(attachmentId, (OutputStream)outStream);
        }
        catch (IOException e) {
            LOGGER.warn("Error happened during attachment download", (Throwable)e);
            response.setStatus(500);
        }
        catch (IllegalArgumentException | AccessDeniedException e) {
            LOGGER.warn("Error happened during attachment download", e);
            response.setStatus(404);
        }
    }

    private String getUploadSummary(String key, Locale locale) {
        return this.messageSource.getMessage(key, null, locale);
    }

    private EntityReference getEntityReference(String entityType, long entityId) {
        String className = StringUtils.capitalize((String)entityType);
        EntityType type = EntityType.fromSimpleName((String)className);
        return new EntityReference(type, Long.valueOf(entityId));
    }

    private EntityType getEntityType(String entityType) {
        String className = StringUtils.capitalize((String)entityType);
        return EntityType.fromSimpleName((String)className);
    }
}

