/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.artificialintelligence.server;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.aiserver.AiServer;
import org.squashtest.tm.service.artificialintelligence.server.AiServerManagerService;
import org.squashtest.tm.service.display.artificialintelligence.server.AiServerDisplayService;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.web.backend.controller.utils.UrlValidator;

@RestController
@RequestMapping(value={"/backend/ai-servers"})
public class AiServerDisplayController {
    private final AiServerDisplayService aiServerDisplayService;
    private final AiServerManagerService aiServerManagerService;

    public AiServerDisplayController(AiServerDisplayService aiServerDisplayService, AiServerManagerService aiServerManagerService) {
        this.aiServerDisplayService = aiServerDisplayService;
        this.aiServerManagerService = aiServerManagerService;
    }

    @PostMapping
    public GridResponse getAllAiServers(@RequestBody GridRequest request) {
        return this.aiServerDisplayService.findAll(request);
    }

    @PostMapping(value={"/new"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public Map<String, Object> createNewAiServer(@RequestBody AiServerFormModel formModel) {
        UrlValidator.checkURL(formModel.baseUrl());
        AiServer server = new AiServer(formModel.name(), formModel.baseUrl(), formModel.description());
        server.setDescription(formModel.description());
        this.aiServerManagerService.persist(server);
        return Collections.singletonMap("id", server.getId());
    }

    @DeleteMapping(value={"/{aiServerIds}"})
    public void deleteServers(@PathVariable List<Long> aiServerIds) {
        this.aiServerManagerService.deleteAiServers(aiServerIds);
    }

    record AiServerFormModel(String name, String baseUrl, String description) {
    }
}

