/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.actionword;

import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.bdd.ActionWord;
import org.squashtest.tm.service.internal.display.dto.actionword.ActionWordDto;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Component
public class ActionWordDtoBuilder {
    private final PermissionEvaluationService permissionService;

    public ActionWordDtoBuilder(PermissionEvaluationService permissionService) {
        this.permissionService = permissionService;
    }

    public ActionWordDto build(ActionWord actionWord, Long actionWordLibraryNodeId) {
        ActionWordDto actionWordDto = new ActionWordDto();
        this.fillBasicAttributes(actionWord, actionWordDto);
        this.fillAuditableAttributes(actionWord, actionWordDto);
        this.fillOtherAttributes(actionWord, actionWordDto);
        actionWordDto.setActionWordLibraryNodeId(actionWordLibraryNodeId);
        return actionWordDto;
    }

    private void fillBasicAttributes(ActionWord actionWord, ActionWordDto actionWordDto) {
        actionWordDto.setId(actionWord.getId());
        actionWordDto.setWord(actionWord.createWord());
        actionWordDto.setDescription(actionWord.getDescription());
        actionWordDto.setProjectName(actionWord.getProject().getName());
    }

    private void fillAuditableAttributes(ActionWord actionWord, ActionWordDto actionWordDto) {
        actionWordDto.setCreatedBy(actionWord.getCreatedBy());
        actionWordDto.setCreatedOn(actionWord.getCreatedOn());
        actionWordDto.setLastModifiedBy(actionWord.getLastModifiedBy());
        actionWordDto.setLastModifiedOn(actionWord.getLastModifiedOn());
    }

    private void fillOtherAttributes(ActionWord actionWord, ActionWordDto actionWordDto) {
        actionWordDto.setWritable(this.permissionService.hasRoleOrPermissionOnObject("ROLE_ADMIN", "WRITE", (Object)actionWord));
    }
}

