/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.actionword;

import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.bdd.ActionWord;
import org.squashtest.tm.service.actionword.ActionWordGridService;
import org.squashtest.tm.service.actionword.ActionWordLibraryNodeService;
import org.squashtest.tm.service.actionword.ActionWordParameterService;
import org.squashtest.tm.service.actionword.ActionWordService;
import org.squashtest.tm.service.internal.display.dto.actionword.ActionWordDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.web.backend.controller.actionword.ActionWordDtoBuilder;

@RestController
@RequestMapping(value={"backend/action-word-view"})
public class ActionWordController {
    private final ActionWordDtoBuilder actionWordDtoBuilder;
    private final ActionWordLibraryNodeService actionWordLibraryNodeService;
    private final ActionWordService actionWordService;
    private final ActionWordGridService actionWordGridService;
    private final ActionWordParameterService actionWordParameterService;

    @Autowired
    public ActionWordController(ActionWordDtoBuilder actionWordDtoBuilder, ActionWordLibraryNodeService actionWordLibraryNodeService, Optional<ActionWordService> actionWordService, Optional<ActionWordGridService> actionWordGridService, ActionWordParameterService actionWordParameterService) {
        this.actionWordDtoBuilder = actionWordDtoBuilder;
        this.actionWordLibraryNodeService = actionWordLibraryNodeService;
        this.actionWordService = actionWordService.orElse(null);
        this.actionWordGridService = actionWordGridService.orElse(null);
        this.actionWordParameterService = actionWordParameterService;
    }

    @GetMapping(value={"/{nodeId}"})
    public ActionWordDto getActionWordView(@PathVariable long nodeId) {
        return this.actionWordDtoBuilder.build(this.actionWordLibraryNodeService.findActionWordByNodeId(Long.valueOf(nodeId)), nodeId);
    }

    @PostMapping(value={"/{actionWordId}/description"})
    public void updateActionWordDescription(@PathVariable long actionWordId, @RequestBody ActionWordPatch patch) {
        this.getActionWordService().changeDescription(actionWordId, patch.description());
    }

    @PostMapping(value={"/{parameterId}/parameter-default-value"})
    public void updateActionWordParameterDefaultValue(@PathVariable long parameterId, @RequestBody ActionWordParameterPatch patch) {
        this.actionWordParameterService.updateParameterDefaultValue(parameterId, patch.defaultValue());
    }

    @PostMapping(value={"/{parameterId}/parameter-name"})
    public void updateActionWordParameterName(@PathVariable long parameterId, @RequestBody ActionWordParameterPatch patch) {
        this.actionWordParameterService.renameParameter(parameterId, patch.name());
    }

    @GetMapping(value={"/{nodeId}/title"})
    public ActionWordTitleModel getActionWordTitle(@PathVariable long nodeId) {
        ActionWord actionWord = this.actionWordLibraryNodeService.findActionWordByNodeId(Long.valueOf(nodeId));
        return new ActionWordTitleModel(actionWord.createWord());
    }

    @PostMapping(value={"/{actionWordId}/implementation"})
    public GridResponse getImplementation(@PathVariable long actionWordId, @RequestBody GridRequest requestParam) {
        return this.getActionWordGridService().findAllImplementationByActionWordId(actionWordId, requestParam);
    }

    @PostMapping(value={"/{actionWordId}/using-test-cases"})
    public GridResponse getUsingTestCases(@PathVariable long actionWordId, @RequestBody GridRequest requestParam) {
        return this.getActionWordGridService().findAllUsingTestCasesByActionWordId(actionWordId, requestParam);
    }

    @PostMapping(value={"/{actionWordId}/parameters"})
    public GridResponse getParameters(@PathVariable long actionWordId, @RequestBody GridRequest requestParam) {
        return this.getActionWordGridService().findAllParametersByActionWordId(actionWordId, requestParam);
    }

    private ActionWordGridService getActionWordGridService() {
        if (Objects.isNull(this.actionWordGridService)) {
            throw new AccessDeniedException("A dedicated plugin is required to manage action words");
        }
        return this.actionWordGridService;
    }

    private ActionWordService getActionWordService() {
        if (Objects.isNull(this.actionWordService)) {
            throw new AccessDeniedException("A dedicated plugin is required to manage action words");
        }
        return this.actionWordService;
    }

    public record ActionWordParameterPatch(String defaultValue, String name) {
    }

    public record ActionWordPatch(String description) {
    }

    public record ActionWordTitleModel(String word) {
    }
}

