/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.security.authentication;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;

public class SinglePageAppAuthenticationFailureHandler
extends SimpleUrlAuthenticationFailureHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SinglePageAppAuthenticationFailureHandler.class);
    @Autowired
    private ObjectMapper objectMapper;

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        LOGGER.debug("Authentication failure for user {}", (Throwable)exception);
        response.setStatus(200);
        response.setContentType("application/json");
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put("authenticated", false);
        response.getOutputStream().print(this.objectMapper.writeValueAsString(data));
    }
}

