/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.config;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class DenyInfrastructureAdminFilter
extends OncePerRequestFilter {
    private static final Set<Pattern> WHITELISTED_URL_PATTERNS = Set.of(Pattern.compile(".*/actuator/.*"), Pattern.compile(".*/api/.*/configuration/.*"), Pattern.compile(".*/api/.*/login-message.*"), Pattern.compile(".*/api/.*/test-automation-servers.*"), Pattern.compile(".*/api/.*/tokens.*"), Pattern.compile(".*/api/.*/welcome-message.*"));
    @Value(value="${squash.cloud-mode-enabled:false}")
    private boolean needsInfrastructureAdmin;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).anyMatch(role -> role.equals("ROLE_INFRASTRUCTURE_ADMIN"))) {
            boolean isUrlDenied = WHITELISTED_URL_PATTERNS.stream().noneMatch(pattern -> pattern.matcher(request.getRequestURI()).matches());
            if (!this.needsInfrastructureAdmin || isUrlDenied) {
                throw new AccessDeniedException("Access is denied");
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

