/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.security.authentication;

import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;

@Component
public class TraceFailedAuthentication
implements ApplicationListener<AbstractAuthenticationFailureEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraceFailedAuthentication.class);

    public void onApplicationEvent(AbstractAuthenticationFailureEvent event) {
        Object details = event.getAuthentication().getDetails();
        if (details instanceof WebAuthenticationDetails) {
            String ipAddress = ((WebAuthenticationDetails)details).getRemoteAddress();
            LOGGER.info("Failed authentication from remote IP {}", new Object[]{ipAddress});
        }
    }
}

