/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.report.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.export.Exporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleCsvExporterConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;
import net.sf.jasperreports.export.SimpleXlsReportConfiguration;
import org.springframework.stereotype.Service;
import org.squashtest.tm.web.backend.report.service.AlreadyMappedException;
import org.squashtest.tm.web.backend.report.service.UnsupportedFormatException;

@Service(value="squashtest.tm.service.JasperReportsService")
public class JasperReportsService {
    private final Map<String, Class<? extends Exporter<?, ?, ?, ?>>> exporterMaps = new HashMap();

    public JasperReportsService() {
        this.registerFormat("csv", JRCsvExporter.class);
        this.registerFormat("xls", JRXlsExporter.class);
    }

    public Set<String> getSupportedformats() {
        return this.exporterMaps.keySet();
    }

    public boolean isSupported(String format) {
        return this.exporterMaps.containsKey(format);
    }

    private void registerFormat(String format, Class<? extends Exporter<?, ?, ?, ?>> jrExporterClass) {
        if (this.isSupported(format)) {
            Class clazz = (Class)this.exporterMaps.get(format);
            throw new AlreadyMappedException("the format " + format + " is already mapped to " + clazz.getName());
        }
        this.exporterMaps.put(format, jrExporterClass);
    }

    private Exporter<?, ?, ?, ?> getExporter(String format) {
        Class exporterClass = (Class)this.exporterMaps.get(format);
        if (exporterClass == null) {
            throw new UnsupportedFormatException("no exporter defined for " + format);
        }
        try {
            return (Exporter)exporterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ExceptionInInitializerError | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getReportAsStream(InputStream jasperStream, String format, Collection<?> dataSource, Map<String, Object> reportParameter) {
        try {
            Exporter exporter = this.getExporter(format);
            JRBeanCollectionDataSource jasperDataSource = new JRBeanCollectionDataSource(dataSource);
            JasperPrint jPrint = JasperFillManager.fillReport((InputStream)jasperStream, reportParameter, (JRDataSource)jasperDataSource);
            File reportFile = File.createTempFile("export", format);
            reportFile.deleteOnExit();
            FileOutputStream reportOut = new FileOutputStream(reportFile);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)reportOut, StandardCharsets.ISO_8859_1);
            SimpleWriterExporterOutput exporterOutput = new SimpleWriterExporterOutput((Writer)writer);
            exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jPrint));
            exporter.setExporterOutput((ExporterOutput)exporterOutput);
            if (exporter instanceof JRCsvExporter) {
                SimpleCsvExporterConfiguration csvConfig = new SimpleCsvExporterConfiguration();
                csvConfig.setFieldDelimiter(";");
                exporter.setConfiguration((ExporterConfiguration)csvConfig);
            } else if (exporter instanceof JRXlsExporter) {
                SimpleXlsReportConfiguration xlsConfig = new SimpleXlsReportConfiguration();
                xlsConfig.setWhitePageBackground(Boolean.valueOf(false));
                exporter.setConfiguration((ReportExportConfiguration)xlsConfig);
            }
            exporter.exportReport();
            return new FileInputStream(reportFile);
        }
        catch (IOException | JRException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

