/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.report.criteria;

import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import org.springframework.util.Assert;
import org.squashtest.tm.api.report.criteria.Criteria;
import org.squashtest.tm.api.report.form.InputType;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.web.backend.report.criteria.EmptyCriteria;
import org.squashtest.tm.web.backend.report.criteria.InconsistentDateFormatException;
import org.squashtest.tm.web.backend.report.criteria.SimpleCriteria;
import org.squashtest.tm.web.backend.report.criteria.SimpleEntryConverter;

class DateEntryConverter
implements SimpleEntryConverter {
    DateEntryConverter() {
    }

    public Criteria convertEntry(String name, Map<String, Object> entry, InputType type) {
        Assert.isTrue((InputType.DATE == type ? 1 : 0) != 0, (String)("Type should be " + String.valueOf(InputType.DATE)));
        String raw = (String)entry.get("value");
        if ("--".equals(raw)) {
            return EmptyCriteria.createEmptyCriteria((String)name, (InputType)type);
        }
        Date value = this.parseDate(raw);
        return new SimpleCriteria(name, (Object)value, type);
    }

    private Date parseDate(String raw) {
        try {
            return DateUtils.parseIso8601Date((String)raw);
        }
        catch (ParseException e) {
            throw new InconsistentDateFormatException(raw, e);
        }
    }
}

