/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.report;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;
import org.squashtest.tm.api.report.BasicReport;
import org.squashtest.tm.api.report.Report;
import org.squashtest.tm.api.report.ReportPlugin;
import org.squashtest.tm.api.report.StandardReportCategory;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.web.backend.report.IdentifiedReportDecorator;
import org.squashtest.tm.web.backend.report.ReportIdentifier;
import org.squashtest.tm.web.backend.report.ReportsRegistry;

@Component
public class ReportsRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportsRegistry.class);
    private static final String UNCHECKED = "unchecked";
    private final MultiValueMap reportsByCategory = new MultiValueMap();
    private final Map<ReportIdentifier, IdentifiedReportDecorator> reportByIdentifier = new ConcurrentHashMap();
    @Autowired(required=false)
    private Collection<ReportPlugin> plugins = Collections.emptyList();
    @Inject
    private MessageSource i18nHelper;

    @PostConstruct
    public void registerReports() {
        for (ReportPlugin plugin : this.plugins) {
            Report[] reports;
            Report[] reportArray = reports = plugin.getReports();
            int n = reports.length;
            int n2 = 0;
            while (n2 < n) {
                Report report = reportArray[n2];
                String pluginNamespace = report.getLabelKey();
                StandardReportCategory category = report.getCategory();
                IdentifiedReportDecorator identifiedReport = this.createIdentifiedReport(report, pluginNamespace);
                this.reportsByCategory.put((Object)category, (Object)identifiedReport);
                this.reportByIdentifier.put(identifiedReport.getIdentifier(), identifiedReport);
                LOGGER.info("Registered report [{}] under Category [{}] along with Namespace [{}]", new Object[]{report, category.getI18nKey(), pluginNamespace});
                ++n2;
            }
        }
    }

    private IdentifiedReportDecorator createIdentifiedReport(Report report, String pluginNamespace) {
        return new IdentifiedReportDecorator(report, pluginNamespace);
    }

    public Set<StandardReportCategory> getCategories() {
        return this.reportsByCategory.keySet();
    }

    public List<IdentifiedReportDecorator> getSortedReports() {
        return new ArrayList(this.reportByIdentifier.values()).stream().sorted(new ReportSorter()).toList();
    }

    public List<StandardReportCategory> getSortedCategories() {
        ArrayList<StandardReportCategory> sortedCategories = new ArrayList<StandardReportCategory>(this.getCategories());
        Collections.sort(sortedCategories, new CategorySorter(this.i18nHelper));
        return sortedCategories;
    }

    public Collection<IdentifiedReportDecorator> findReports(StandardReportCategory category) {
        Collection res = (Collection)this.reportsByCategory.get((Object)category);
        return res == null ? Collections.emptyList() : res;
    }

    public Map<StandardReportCategory, Collection<BasicReport>> getReportsByCategory() {
        return this.reportsByCategory;
    }

    public Map<StandardReportCategory, Collection<IdentifiedReportDecorator>> getSortedReportsByCategory() {
        HashMap<StandardReportCategory, Collection<IdentifiedReportDecorator>> sortedMap = new HashMap<StandardReportCategory, Collection<IdentifiedReportDecorator>>(this.reportsByCategory.size());
        for (StandardReportCategory categ : this.reportsByCategory.keySet()) {
            ArrayList sortedReports = new ArrayList(this.reportsByCategory.getCollection((Object)categ));
            Collections.sort(sortedReports, new ReportSorter());
            sortedMap.put(categ, sortedReports);
        }
        return sortedMap;
    }

    public IdentifiedReportDecorator findReport(String namespace) {
        return (IdentifiedReportDecorator)this.reportByIdentifier.get(new ReportIdentifier(namespace));
    }
}

