/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.model.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.service.internal.dto.CustomFieldModelFactory;
import org.squashtest.tm.service.internal.dto.CustomFieldValueModel;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;

public class CleanCustomFieldValueSerializer
extends JsonSerializer<String> {
    public void serialize(String s, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        Object target = jsonGenerator.currentValue();
        if (CustomFieldValueModel.class.isAssignableFrom(target.getClass())) {
            CustomFieldValueModel model = (CustomFieldValueModel)target;
            String input = model.getBinding().getCustomField().getInputType().getEnumName();
            s = this.cleanCustomFieldValue(s, input);
        } else if (CustomFieldModelFactory.SingleValuedCustomFieldModel.class.isAssignableFrom(target.getClass())) {
            CustomFieldModelFactory.SingleValuedCustomFieldModel model = (CustomFieldModelFactory.SingleValuedCustomFieldModel)target;
            String input = model.getInputType().getEnumName();
            s = this.cleanCustomFieldValue(s, input);
        }
        jsonGenerator.writeString(s);
    }

    public String cleanCustomFieldValue(String s, String input) {
        if (input.equals(InputType.RICH_TEXT.name())) {
            String valueModel = HtmlUtils.htmlUnescape((String)s);
            s = HTMLCleanupUtils.cleanHtml((String)valueModel);
            s = HTMLCleanupUtils.cleanHtml((String)s);
        } else if (input.equals(InputType.PLAIN_TEXT.name())) {
            String valueModel = HtmlUtils.htmlUnescape((String)s);
            s = HTMLCleanupUtils.stripJavascript((String)valueModel);
            s = HTMLCleanupUtils.stripJavascript((String)s);
        } else {
            String valueModel = HtmlUtils.htmlUnescape((String)s);
            valueModel = HtmlUtils.htmlEscape((String)valueModel);
            s = HtmlUtils.htmlUnescape((String)valueModel);
        }
        return s;
    }
}

