/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.manager.wizard;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.NoSuchElementException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.map.MultiValueMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.squashtest.tm.api.plugin.ConfigurablePlugin;
import org.squashtest.tm.api.wizard.WorkspaceWizard;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.library.PluginReferencer;
import org.squashtest.tm.domain.project.LibraryPluginBinding;
import org.squashtest.tm.service.project.GenericProjectFinder;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.web.backend.manager.wizard.WorkspaceWizardManager;
import org.squashtest.tm.web.backend.manager.wizard.WorkspaceWizardManagerImpl;

@Service
public class WorkspaceWizardManagerImpl
implements WorkspaceWizardManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkspaceWizardManagerImpl.class);
    @Autowired(required=false)
    private Collection<WorkspaceWizard> wizards = Collections.emptyList();
    private final MultiValueMap wizardsByWorkspace = new MultiValueMap();
    @Inject
    private GenericProjectFinder projectFinder;
    @Inject
    private GenericProjectManagerService projectManager;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$squashtest$tm$api$workspace$WorkspaceType;

    @PostConstruct
    public void registerWizards() {
        for (WorkspaceWizard wizard : this.wizards) {
            LOGGER.info("Registering workspace wizard {} for workspace {}", new Object[]{wizard, wizard.getDisplayWorkspace()});
            this.wizardsByWorkspace.put((Object)wizard.getDisplayWorkspace(), (Object)wizard);
        }
    }

    public Collection<WorkspaceWizard> findAllByWorkspace(WorkspaceType workspace) {
        Collection collection = this.wizardsByWorkspace.getCollection((Object)workspace);
        if (collection == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(collection);
    }

    public WorkspaceWizard findById(String wizardId) {
        for (WorkspaceWizard wizard : this.findAll()) {
            if (!wizard.getId().equals(wizardId)) continue;
            return wizard;
        }
        throw new NoSuchElementException("cannot find WorkspaceWizard with id " + wizardId);
    }

    public Collection<WorkspaceWizard> findAll() {
        return Collections.unmodifiableCollection(this.wizards);
    }

    public Collection<WorkspaceWizard> findEnabledWizards(long projectId) {
        return this.findEnabledWizards(projectId, new WorkspaceType[]{WorkspaceType.TEST_CASE_WORKSPACE, WorkspaceType.REQUIREMENT_WORKSPACE, WorkspaceType.CAMPAIGN_WORKSPACE});
    }

    public Collection<WorkspaceWizard> findEnabledWizards(long projectId, WorkspaceType workspace) {
        Collection allWizards = this.findAllByWorkspace(workspace);
        Collection enabledWizardIds = this.findEnabledWizardIds(projectId, workspace);
        BelongsToList predicate = new BelongsToList(enabledWizardIds);
        return this.filterWizards(allWizards, (Predicate)predicate);
    }

    private Collection<WorkspaceWizard> filterWizards(Collection<WorkspaceWizard> wizards, Predicate predicate) {
        ArrayList<WorkspaceWizard> res = new ArrayList<WorkspaceWizard>(wizards);
        CollectionUtils.filter(res, (Predicate)predicate);
        return res;
    }

    public Collection<WorkspaceWizard> findEnabledWizards(long projectId, WorkspaceType ... workspaces) {
        HashSet<WorkspaceWizard> allWizards = new HashSet<WorkspaceWizard>(this.wizards.size());
        WorkspaceType[] workspaceTypeArray = workspaces;
        int n = workspaces.length;
        int n2 = 0;
        while (n2 < n) {
            WorkspaceType workspace = workspaceTypeArray[n2];
            allWizards.addAll(this.findEnabledWizards(projectId, workspace));
            ++n2;
        }
        return allWizards;
    }

    public Collection<WorkspaceWizard> findDisabledWizards(long projectId) {
        return this.findDisabledWizards(projectId, new WorkspaceType[]{WorkspaceType.TEST_CASE_WORKSPACE, WorkspaceType.REQUIREMENT_WORKSPACE, WorkspaceType.CAMPAIGN_WORKSPACE});
    }

    public Collection<WorkspaceWizard> findDisabledWizards(long projectId, WorkspaceType workspace) {
        Collection allWizards = this.findAllByWorkspace(workspace);
        Collection enabledWizardIds = this.findEnabledWizardIds(projectId, workspace);
        AbsentFromList predicate = new AbsentFromList(enabledWizardIds);
        return this.filterWizards(allWizards, (Predicate)predicate);
    }

    public Collection<WorkspaceWizard> findDisabledWizards(long projectId, WorkspaceType ... workspaces) {
        HashSet<WorkspaceWizard> allWizards = new HashSet<WorkspaceWizard>();
        WorkspaceType[] workspaceTypeArray = workspaces;
        int n = workspaces.length;
        int n2 = 0;
        while (n2 < n) {
            WorkspaceType workspace = workspaceTypeArray[n2];
            allWizards.addAll(this.findDisabledWizards(projectId, workspace));
            ++n2;
        }
        return allWizards;
    }

    public Boolean isActivePlugin(WorkspaceWizard plugin, long projectId) {
        PluginReferencer library = this.findLibrary(projectId, plugin.getDisplayWorkspace());
        LibraryPluginBinding binding = library.getPluginBinding(plugin.getId());
        if (binding != null && binding.getActive().booleanValue()) {
            return true;
        }
        return false;
    }

    public Boolean hasConfiguration(WorkspaceWizard plugin, long projectId) {
        return this.projectManager.pluginHasConfigurationOrSynchronisations((ConfigurablePlugin)plugin, projectId);
    }

    /*
     * Exception decompiling
     */
    private PluginReferencer<?> findLibrary(long projectId, WorkspaceType workspace) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Collection<String> findEnabledWizardIds(long projectId, WorkspaceType workspace) {
        return this.findLibrary(projectId, workspace).getEnabledPlugins();
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$squashtest$tm$api$workspace$WorkspaceType() {
        if ($SWITCH_TABLE$org$squashtest$tm$api$workspace$WorkspaceType != null) {
            return $SWITCH_TABLE$org$squashtest$tm$api$workspace$WorkspaceType;
        }
        int[] nArray = new int[WorkspaceType.values().length];
        try {
            nArray[WorkspaceType.AUTOMATION_TESTER_WORKSPACE.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkspaceType.AUTOMATION_WORKSPACE.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkspaceType.CAMPAIGN_WORKSPACE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkspaceType.CUSTOM_REPORT_WORKSPACE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkspaceType.REQUIREMENT_WORKSPACE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkspaceType.TEST_CASE_WORKSPACE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$squashtest$tm$api$workspace$WorkspaceType = nArray;
        return nArray;
    }
}

