/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.helper;

import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import java.util.Locale;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.Level;
import org.squashtest.tm.web.backend.helper.LabelFormatter;

@Component
@Scope(value="prototype")
public class LevelLabelFormatter
implements LabelFormatter<Level> {
    private final MessageSource messageSource;
    private Locale locale = Locale.getDefault();
    private boolean escapeHtml = true;

    @Inject
    public LevelLabelFormatter(@NotNull MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public LabelFormatter<Level> useLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public String formatLabel(Level toFormat) {
        String label = toFormat.getLevel() + "-" + this.messageSource.getMessage(toFormat.getI18nKey(), null, this.locale);
        return this.escapeHtml ? StringEscapeUtils.escapeHtml4((String)label) : label;
    }

    public LabelFormatter<Level> escapeHtml() {
        this.escapeHtml = true;
        return this;
    }

    public LabelFormatter<Level> plainText() {
        this.escapeHtml = false;
        return this;
    }
}

