/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.multipart.support.MultipartFilter;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.web.backend.exceptionresolver.MaxUploadSizeErrorModel;

public class MultipartFilterExceptionAware
extends MultipartFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultipartFilterExceptionAware.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            super.doFilterInternal(request, response, filterChain);
        }
        catch (MaxUploadSizeExceededException ex) {
            this.handleException(ex, response);
        }
    }

    protected void handleException(MaxUploadSizeExceededException ex, HttpServletResponse response) throws IOException {
        LOGGER.error("exception while uploading file", (Throwable)ex);
        HashMap<String, MaxUploadSizeErrorModel> mainError = new HashMap<String, MaxUploadSizeErrorModel>();
        mainError.put("maxUploadError", new MaxUploadSizeErrorModel(ex));
        String strErr = new ObjectMapper().writeValueAsString(mainError);
        response.setStatus(413);
        response.setContentType("application/json");
        response.getWriter().write(strErr);
    }
}

