/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.fileupload;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;
import org.squashtest.tm.service.configuration.ConfigurationService;

public class SquashMultipartResolver
extends StandardServletMultipartResolver {
    private static final long DEFAULT_MAX_UPLOAD_SIZE = -1L;
    private ConfigurationService configurationService;
    private String maxUploadSizeKey = "uploadfilter.upload.sizeLimitInBytes";
    private long maxUploadSize = -1L;

    public void setMaxUploadSizeKey(String maxUploadSizeKey) {
        this.maxUploadSizeKey = maxUploadSizeKey;
    }

    void setConfigurationService(ConfigurationService service) {
        this.configurationService = service;
    }

    void updateConfig() {
        String uploadLimit = this.configurationService.findConfiguration(this.maxUploadSizeKey);
        this.maxUploadSize = Long.parseLong(uploadLimit);
    }

    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest request) throws MultipartException {
        MultipartHttpServletRequest multipartRequest = super.resolveMultipart(request);
        if (this.maxUploadSize != -1L && multipartRequest.getRequestHeaders().getContentLength() > this.maxUploadSize) {
            throw new MaxUploadSizeExceededException(this.maxUploadSize);
        }
        return multipartRequest;
    }
}

