/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.exceptionresolver;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.squashtest.tm.core.foundation.exception.SimpleException;
import org.squashtest.tm.web.backend.exceptionresolver.ExceptionResolverUtils;
import org.squashtest.tm.web.backend.exceptionresolver.MimeType;

@Component
public class HandlerSimpleExceptionResolver
extends AbstractHandlerExceptionResolver {
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (this.exceptionIsHandled(ex)) {
            return this.handleException(request, response, ex);
        }
        return null;
    }

    private ModelAndView handleException(HttpServletRequest request, HttpServletResponse response, Exception ex) {
        SimpleException simpleEx = (SimpleException)ex;
        response.setStatus(412);
        String message = simpleEx.getMessage();
        if (ExceptionResolverUtils.clientAcceptsMIME((HttpServletRequest)request, (MimeType)MimeType.APPLICATION_JSON)) {
            return ExceptionResolverUtils.formatJsonResponse((String)message);
        }
        if (ExceptionResolverUtils.clientAcceptsMIME((HttpServletRequest)request, (MimeType)MimeType.TEXT_PLAIN)) {
            return ExceptionResolverUtils.formatPlainTextResponse((String)message);
        }
        return null;
    }

    private boolean exceptionIsHandled(Exception ex) {
        return SimpleException.class.isAssignableFrom(ex.getClass());
    }
}

