/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.exceptionresolver;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;
import org.squashtest.tm.web.backend.exceptionresolver.ConstraintViolationHandler;
import org.squashtest.tm.web.backend.exceptionresolver.DeprecatedFieldValidationErrorModel;
import org.squashtest.tm.web.backend.exceptionresolver.HasDefaultAsRequiredViolationHandler;
import org.squashtest.tm.web.backend.exceptionresolver.MimeType;
import org.squashtest.tm.web.backend.exceptionresolver.PropertyPathConstraintViolationHandler;

@Component
public class HandlerGenericValidation
extends AbstractHandlerExceptionResolver {
    private final List<ConstraintViolationHandler> constraintViolationHandlers = new ArrayList();

    public HandlerGenericValidation() {
        this.constraintViolationHandlers.add(new HasDefaultAsRequiredViolationHandler());
        this.constraintViolationHandlers.add(new PropertyPathConstraintViolationHandler());
    }

    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (this.exceptionIsHandled(ex) && this.clientAcceptsJson(request)) {
            response.setStatus(412);
            ConstraintViolationException cve = (ConstraintViolationException)ex;
            List errors = this.buildFieldValidationErrors(cve);
            return new ModelAndView((View)new MappingJackson2JsonView(), "fieldValidationErrors", (Object)errors);
        }
        return null;
    }

    private List<DeprecatedFieldValidationErrorModel> buildFieldValidationErrors(ConstraintViolationException cve) {
        ArrayList<DeprecatedFieldValidationErrorModel> ves = new ArrayList<DeprecatedFieldValidationErrorModel>();
        Set constraintList = cve.getConstraintViolations();
        for (ConstraintViolation aConstraintList : constraintList) {
            this.addFieldValidationError(aConstraintList, ves);
        }
        return ves;
    }

    private void addFieldValidationError(ConstraintViolation<?> violation, List<DeprecatedFieldValidationErrorModel> ves) {
        for (ConstraintViolationHandler handler : this.constraintViolationHandlers) {
            if (handler.handle(violation, ves)) break;
        }
    }

    private boolean exceptionIsHandled(Exception ex) {
        return ex instanceof ConstraintViolationException;
    }

    private boolean clientAcceptsJson(HttpServletRequest request) {
        Enumeration e = request.getHeaders("Accept");
        while (e.hasMoreElements()) {
            String header = (String)e.nextElement();
            if (!StringUtils.containsIgnoreCase((CharSequence)StringUtils.trimToEmpty((String)header), (CharSequence)MimeType.ANYTHING.requestHeaderValue()) && !StringUtils.containsIgnoreCase((CharSequence)StringUtils.trimToEmpty((String)header), (CharSequence)MimeType.APPLICATION_JSON.requestHeaderValue())) continue;
            return true;
        }
        return false;
    }
}

