/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.exceptionresolver;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.squashtest.tm.core.foundation.exception.EntityDoesNotExistException;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.web.backend.exceptionresolver.ExceptionResolverUtils;
import org.squashtest.tm.web.backend.exceptionresolver.MimeType;

@Component
public class HandlerEntityDoesNotExistExceptionResolver
extends AbstractHandlerExceptionResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(HandlerEntityDoesNotExistExceptionResolver.class);

    @ExceptionHandler(value={EntityDoesNotExistException.class})
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (ex instanceof EntityDoesNotExistException) {
            EntityDoesNotExistException entityDoesNotExistException = (EntityDoesNotExistException)ex;
            String message = entityDoesNotExistException.getMessage();
            LOGGER.trace(message, new Object[0]);
            response.setStatus(404);
            if (ExceptionResolverUtils.clientAcceptsMIME((HttpServletRequest)request, (MimeType)MimeType.APPLICATION_JSON)) {
                return ExceptionResolverUtils.formatJsonResponse((String)message);
            }
            if (ExceptionResolverUtils.clientAcceptsMIME((HttpServletRequest)request, (MimeType)MimeType.TEXT_PLAIN)) {
                return ExceptionResolverUtils.formatPlainTextResponse((String)message);
            }
        }
        return null;
    }
}

