/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.exceptionresolver;

import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;
import org.squashtest.tm.exception.CompositeDomainException;
import org.squashtest.tm.exception.DomainException;
import org.squashtest.tm.web.backend.exceptionresolver.DeprecatedFieldValidationErrorModel;
import org.squashtest.tm.web.backend.exceptionresolver.ExceptionResolverUtils;
import org.squashtest.tm.web.backend.exceptionresolver.MimeType;

@Component
public class HandlerCompositeDomainExceptionResolver
extends AbstractHandlerExceptionResolver {
    @Inject
    private MessageSource messageSource;

    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (this.exceptionIsHandled(ex) && ExceptionResolverUtils.clientAcceptsMIME((HttpServletRequest)request, (MimeType)MimeType.APPLICATION_JSON)) {
            response.setStatus(412);
            CompositeDomainException cdex = (CompositeDomainException)ex;
            List errors = this.buildFieldValidationErrors(cdex, request.getLocale());
            return new ModelAndView((View)new MappingJackson2JsonView(), "fieldValidationErrors", (Object)errors);
        }
        return null;
    }

    private List<DeprecatedFieldValidationErrorModel> buildFieldValidationErrors(CompositeDomainException cdex, Locale locale) {
        ArrayList<DeprecatedFieldValidationErrorModel> ves = new ArrayList<DeprecatedFieldValidationErrorModel>();
        for (DomainException dex : cdex.getExceptions()) {
            String message = dex.getMessage();
            if (!dex.getI18nKey().isEmpty()) {
                message = this.messageSource.getMessage(dex.getI18nKey(), dex.getI18nParams(), locale);
            }
            ves.add(new DeprecatedFieldValidationErrorModel(dex.getObjectName(), dex.getField(), message, dex.getFieldValue()));
        }
        return ves;
    }

    private boolean exceptionIsHandled(Exception ex) {
        return ex instanceof CompositeDomainException;
    }
}

