/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.exceptionresolver;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;
import org.squashtest.tm.web.backend.exceptionresolver.HandlerSimpleExceptionResolver;
import org.squashtest.tm.web.backend.exceptionresolver.MimeType;

public final class ExceptionResolverUtils {
    private ExceptionResolverUtils() {
    }

    public static boolean clientAcceptsMIME(HttpServletRequest request, MimeType type) {
        Enumeration e = request.getHeaders("Accept");
        while (e.hasMoreElements()) {
            String header = (String)e.nextElement();
            if (!StringUtils.containsIgnoreCase((CharSequence)StringUtils.trimToEmpty((String)header), (CharSequence)type.requestHeaderValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean clientAcceptsMIMEOrAnything(HttpServletRequest request, MimeType type) {
        Enumeration e = request.getHeaders("Accept");
        while (e.hasMoreElements()) {
            String header = (String)e.nextElement();
            if (!StringUtils.containsIgnoreCase((CharSequence)StringUtils.trimToEmpty((String)header), (CharSequence)type.requestHeaderValue()) && !StringUtils.containsIgnoreCase((CharSequence)StringUtils.trimToEmpty((String)header), (CharSequence)MimeType.ANYTHING.requestHeaderValue())) continue;
            return true;
        }
        return false;
    }

    public static ModelAndView formatPlainTextResponse(String message) {
        HandlerSimpleExceptionResolver.PlainTextView view = new HandlerSimpleExceptionResolver.PlainTextView();
        return new ModelAndView((View)view, "simpleError", (Object)message);
    }

    public static ModelAndView formatJsonResponse(String message) {
        return new ModelAndView((View)new MappingJackson2JsonView(), "error", (Object)message);
    }
}

