/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.thirdpartyserver;

import jakarta.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.AuthenticationStatus;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.service.bugtracker.BugTrackersLocalService;
import org.squashtest.tm.service.internal.servers.OAuth2ConsumerService;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.user.UserAccountService;

@Controller
@RequestMapping(value={"backend/servers"})
public class ThirdPartyServersAuthenticationController {
    private static final String REDIRECT = "redirect:";
    @Inject
    private BugTrackersLocalService btService;
    @Inject
    private OAuth2ConsumerService oAuth2ConsumerService;
    @Inject
    private UserAccountService userService;
    @Inject
    private BugTrackerFinderService bugTrackerFinderService;

    @GetMapping(value={"/{serverId}/authentication"}, produces={"application/json"})
    @ResponseBody
    public AuthenticationStatus getAuthenticationStatus(@PathVariable(value="serverId") Long serverId) {
        return this.btService.checkAuthenticationStatus(serverId);
    }

    @ResponseBody
    @PostMapping(value={"/{serverId}/authentication"})
    public void authenticate(@RequestBody ManageableCredentials credentials, @PathVariable(value="serverId") long serverId) {
        this.btService.validateManageableCredentials(serverId, credentials, false);
        this.userService.saveCurrentUserCredentials(serverId, credentials);
    }

    @GetMapping(value={"/{serverId}/authentication/oauth2"})
    public String authenticateOauth2(@PathVariable(value="serverId") long serverId) {
        BugTracker bugTracker = this.bugTrackerFinderService.findById(serverId);
        String oauth2AuthenticationUrl = this.oAuth2ConsumerService.getOauth2AuthenticationUrl(bugTracker);
        return REDIRECT + oauth2AuthenticationUrl;
    }

    @PostMapping(value={"/{serverId}/authentication/oauth2/token"})
    @ResponseBody
    public void askOauth2Token(@PathVariable(value="serverId") long serverId, @RequestParam(value="code") String code) {
        this.oAuth2ConsumerService.getCurrentUserOauth2token(serverId, code);
    }
}

