/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.tf;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.core.foundation.exception.InvalidUrlException;
import org.squashtest.tm.core.foundation.lang.UrlUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.exception.WrongUrlException;
import org.squashtest.tm.exception.tf.WrongPriorityFormatException;
import org.squashtest.tm.service.display.testcase.TestCaseDisplayService;
import org.squashtest.tm.service.internal.display.dto.testcase.TestCaseDto;
import org.squashtest.tm.service.testcase.TestCaseModificationService;
import org.squashtest.tm.service.tf.AutomationRequestModificationService;
import org.squashtest.tm.web.backend.controller.tf.AutomationModificationViewController;
import org.squashtest.tm.web.backend.model.testautomation.TATestNode;
import org.squashtest.tm.web.backend.model.testautomation.TATestNodeListBuilder;

@RestController
@RequestMapping(value={"/backend/automation-requests"})
public class AutomationModificationViewController {
    public static final Logger LOGGER = LoggerFactory.getLogger(AutomationModificationViewController.class);
    private static final String TEST_CASE_ID = "testCaseId";
    private static final String PATH = "path";
    private final TestCaseModificationService testCaseModificationService;
    private final TestCaseDisplayService testCaseDisplayService;
    private final AutomationRequestModificationService automationRequestModificationService;

    public AutomationModificationViewController(TestCaseModificationService testCaseModificationService, TestCaseDisplayService testCaseDisplayService, AutomationRequestModificationService automationRequestModificationService) {
        this.testCaseModificationService = testCaseModificationService;
        this.testCaseDisplayService = testCaseDisplayService;
        this.automationRequestModificationService = automationRequestModificationService;
    }

    @PostMapping(value={"/{tcIds}/status"})
    public List<TestCaseDto> changeStatus(@PathVariable List<Long> tcIds, @RequestBody String status) {
        this.automationRequestModificationService.changeAutomationRequestStatus(tcIds, AutomationRequestStatus.valueOf((String)status));
        return tcIds.stream().map(arg_0 -> ((TestCaseDisplayService)this.testCaseDisplayService).getTestCaseView(arg_0)).toList();
    }

    @PostMapping(value={"/{tcIds}/request-status"})
    public Map<Long, String> changeAutomationRequestStatus(@PathVariable List<Long> tcIds, @RequestBody TestCaseAutomationPatch patch) {
        AutomationRequestModificationService.ChangeAutomatedRequestStatusResult changeStatusResult = this.automationRequestModificationService.changeAutomationRequestStatus(tcIds, AutomationRequestStatus.valueOf((String)patch.getRequestStatus()));
        return changeStatusResult.testCaseNameWithoutTAScriptById;
    }

    @PostMapping(value={"/{tcIds}/unassign"})
    public void unassignedUser(@PathVariable(value="tcIds") List<Long> tcIds) {
        this.automationRequestModificationService.unassignRequests(tcIds);
    }

    @PostMapping(value={"{testCaseId}/tests"}, params={"path"})
    public String bindAutomatedTest(@PathVariable(value="testCaseId") long testCaseId, @RequestParam(value="path") String testPath) {
        this.testCaseModificationService.bindAutomatedTestByAutomationProgrammer(Long.valueOf(testCaseId), testPath);
        return testPath;
    }

    @GetMapping(value={"{testCaseId}/tests"})
    public Collection<TATestNode> findAssignableAutomatedTests(@PathVariable(value="testCaseId") Long testCaseId) {
        Collection projectContents = this.testCaseModificationService.findAssignableAutomationTestsToAutomationProgramer(testCaseId.longValue());
        return new TATestNodeListBuilder().build(projectContents);
    }

    @PostMapping(value={"{testCaseId}/automatedTestTechnology"})
    public void changeAutomatedTestTechnology(@RequestBody TestCaseAutomationPatch patch, @PathVariable long testCaseId) {
        if (patch.getAutomatedTestTechnology() != null) {
            this.testCaseModificationService.changeAutomatedTestTechnology(testCaseId, patch.getAutomatedTestTechnology().longValue());
        } else {
            this.testCaseModificationService.unbindAutomatedTestTechnology(testCaseId);
        }
    }

    @PostMapping(value={"{testCaseId}/automatedTestReference"})
    public void changeAutomatedTestReference(@RequestBody TestCaseAutomationPatch patch, @PathVariable long testCaseId) {
        this.testCaseModificationService.changeAutomatedTestReference(testCaseId, patch.getAutomatedTestReference());
    }

    @PostMapping(value={"{testCaseId}/automationPriority"})
    public void changeAutomationPriority(@RequestBody TestCaseAutomationPatch patch, @PathVariable long testCaseId) {
        try {
            Integer newPriority = patch.automationPriority.isEmpty() ? null : Integer.valueOf(Integer.parseInt(patch.automationPriority));
            this.testCaseModificationService.changeAutomationPriority(testCaseId, newPriority);
        }
        catch (NumberFormatException nfe) {
            throw new WrongPriorityFormatException((Exception)nfe);
        }
    }

    @PostMapping(value={"/{tcIds}/assign"})
    public void assigneeToAutomationReq(@PathVariable(value="tcIds") List<Long> tcIds) {
        this.automationRequestModificationService.assignedToRequest(tcIds);
    }

    @PostMapping(value={"/{tcIds}/associate-TA-script"})
    public Map<Long, String> resolveTAScriptAssociation(@PathVariable(value="tcIds") List<Long> tcIds) {
        return this.automationRequestModificationService.updateTAScript(tcIds);
    }

    @PostMapping(value={"/associate-TA-script"}, params={"iterationId"})
    public Map<Long, String> resolveTAScriptAssociationForIteration(@RequestParam(value="iterationId") long iterationId) {
        return this.automationRequestModificationService.updateTAScriptForIteration(Long.valueOf(iterationId));
    }

    @PostMapping(value={"/associate-TA-script"}, params={"testSuiteId"})
    public Map<Long, String> resolveTAScriptAssociationForTestSuite(@RequestParam(value="testSuiteId") long testSuiteId) {
        return this.automationRequestModificationService.updateTAScriptForTestSuite(Long.valueOf(testSuiteId));
    }

    @PostMapping(value={"/associate-TA-script"}, params={"testPlanItemsIds[]"})
    public Map<Long, String> resolveTAScriptAssociationForIterationItems(@RequestParam(value="testPlanItemsIds[]") List<Long> testPlanIds) {
        return this.automationRequestModificationService.updateTAScriptForItems(testPlanIds);
    }

    @PostMapping(value={"/{tcId}/source-code-repository-url"})
    public void changeSourceCodeRepositoryUrl(@PathVariable Long tcId, @RequestBody TestCaseAutomationPatch patch) throws WrongUrlException {
        String testCaseSourceCodeRepositoryUrl = patch.getTestCaseSourceRepositoryUrl();
        if (!(testCaseSourceCodeRepositoryUrl = testCaseSourceCodeRepositoryUrl.substring(0, Math.min(testCaseSourceCodeRepositoryUrl.length(), 255))).isEmpty()) {
            try {
                UrlUtils.toUrl((String)testCaseSourceCodeRepositoryUrl);
            }
            catch (InvalidUrlException iue) {
                throw new WrongUrlException("url", (Throwable)iue);
            }
        }
        LOGGER.trace("Test case {}: updated git repository url to {}", new Object[]{tcId, testCaseSourceCodeRepositoryUrl});
    }
}

