/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.test.automation.server.environments.unrestricted;

import java.util.Map;
import java.util.Objects;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.display.test.automation.server.TestAutomationServerDisplayService;
import org.squashtest.tm.service.internal.display.dto.automatedexecutionenvironments.EnvironmentSelectionPanelDto;
import org.squashtest.tm.service.internal.display.dto.automatedexecutionenvironments.ExecutionEnvironmentCountDto;
import org.squashtest.tm.service.project.GenericProjectFinder;
import org.squashtest.tm.service.servers.StoredCredentialsManager;
import org.squashtest.tm.service.testautomation.environment.AutomatedExecutionEnvironmentService;
import org.squashtest.tm.web.backend.controller.form.model.StringList;
import org.squashtest.tm.web.backend.controller.test.automation.server.environments.AbstractTAEnvironmentsController;

@RestController
@RequestMapping(value={"/backend/test-automation/"})
public class UnrestrictedTAEnvironmentsController
extends AbstractTAEnvironmentsController {
    private static final String ITERATION = "iteration";
    private static final String TEST_SUITE = "test-suite";

    public UnrestrictedTAEnvironmentsController(AutomatedExecutionEnvironmentService automatedExecutionEnvironmentService, TestAutomationServerDisplayService testAutomationServerDisplayService, GenericProjectFinder genericProjectFinder, StoredCredentialsManager storedCredentialsManager) {
        super(automatedExecutionEnvironmentService, storedCredentialsManager, genericProjectFinder, testAutomationServerDisplayService);
    }

    @GetMapping(value={"{projectId}/available-tags"})
    public StringList getAllAvailableProjectEnvironmentTags(@PathVariable long projectId) {
        Long testAutomationServerId = this.getTestAutomationServerIdUnsecured(projectId);
        return this.getAvailableProjectEnvironmentTags(projectId, testAutomationServerId);
    }

    @GetMapping(value={"{projectId}/automated-execution-environments/all"})
    public EnvironmentSelectionPanelDto getProjectEnvironments(@PathVariable Long projectId) {
        Long testAutomationServerId = this.getTestAutomationServerIdUnsecured(projectId.longValue());
        return this.getProjectEnvironmentsPanel(projectId.longValue(), testAutomationServerId);
    }

    @GetMapping(value={"{entityType}/{entityId}/automated-execution-environments-statuses-count"})
    public ExecutionEnvironmentCountDto getAutomatedExecutionEnvironmentsStatusesCountForEntity(@PathVariable String entityType, @PathVariable Long entityId) {
        if (!TEST_SUITE.equals(entityType) && !ITERATION.equals(entityType)) {
            throw new IllegalArgumentException("Invalid entity type, expected 'test-suite' or 'iteration', got " + entityType);
        }
        Map projectAndServerIds = entityType.equals(ITERATION) ? this.testAutomationServerDisplayService.findProjectAndServerIdsByIterationId(entityId) : this.testAutomationServerDisplayService.findProjectAndServerIdsByTestSuiteId(entityId);
        return this.automatedExecutionEnvironmentService.getExecutionEnvironmentCountDto(projectAndServerIds);
    }

    private Long getTestAutomationServerIdUnsecured(long genericProjectId) {
        return Objects.requireNonNull(this.testAutomationServerDisplayService.findTestAutomationServerIdByGenericProjectIdUnsecured(genericProjectId), String.format("Expect project with ID %d to have a test automation server bound.", genericProjectId));
    }
}

