/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.team;

import jakarta.inject.Inject;
import jakarta.validation.Valid;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.users.Team;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.exception.user.LoginAlreadyExistsException;
import org.squashtest.tm.service.display.team.TeamDisplayService;
import org.squashtest.tm.service.internal.display.dto.ProjectPermissionDto;
import org.squashtest.tm.service.internal.display.dto.testcase.TeamMemberDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.project.ProjectsPermissionManagementService;
import org.squashtest.tm.service.user.CustomTeamModificationService;
import org.squashtest.tm.service.user.TeamModificationService;
import org.squashtest.tm.web.backend.controller.team.TeamsController;

@RestController
@RequestMapping(value={"/backend/teams"})
public class TeamsController {
    private final TeamDisplayService teamDisplayService;
    private final CustomTeamModificationService customTeamModificationService;
    private final TeamModificationService teamModificationService;
    private final ProjectsPermissionManagementService permissionService;

    @Inject
    public TeamsController(TeamDisplayService teamDisplayService, CustomTeamModificationService customTeamModificationService, TeamModificationService teamModificationService, ProjectsPermissionManagementService permissionService) {
        this.teamDisplayService = teamDisplayService;
        this.customTeamModificationService = customTeamModificationService;
        this.teamModificationService = teamModificationService;
        this.permissionService = permissionService;
    }

    @PostMapping
    public GridResponse getAllTeams(@RequestBody GridRequest request) {
        return this.teamDisplayService.findAll(request);
    }

    @PostMapping(value={"/new"})
    public Map<String, Object> addTeam(@Valid @RequestBody Team team) {
        HashMap<String, Object> tempReturn = new HashMap<String, Object>();
        try {
            this.customTeamModificationService.persist(team);
            tempReturn.put("id", team.getId());
        }
        catch (NameAlreadyInUseException ex) {
            ex.setObjectName("add-team");
            throw ex;
        }
        return tempReturn;
    }

    @PostMapping(value={"/{teamId}/name"})
    public void changeName(@PathVariable long teamId, @RequestBody TeamPatch patch) {
        try {
            this.teamModificationService.changeName(teamId, patch.getName());
        }
        catch (LoginAlreadyExistsException ex) {
            throw new NameAlreadyInUseException("team", "add-team", "name", (Exception)((Object)ex));
        }
    }

    @PostMapping(value={"/{teamId}/description"})
    public void changeDescription(@PathVariable Long teamId, @RequestBody TeamPatch patch) {
        this.teamModificationService.changeDescription(teamId.longValue(), patch.getDescription());
    }

    @DeleteMapping(value={"/{teamIds}"})
    public void deleteTeams(@PathVariable(value="teamIds") List<Long> teamIds) {
        this.customTeamModificationService.deleteTeam(teamIds);
    }

    @PostMapping(value={"/{teamId}/projects/{projectIds}/permissions/{profileId}"})
    public Map<String, List<ProjectPermissionDto>> addNewPermissions(@PathVariable long teamId, @PathVariable List<Long> projectIds, @PathVariable long profileId) {
        this.permissionService.addNewPermissionToProject(teamId, projectIds, profileId);
        return Collections.singletonMap("projectPermissions", this.teamDisplayService.getProjectPermissions(Long.valueOf(teamId)));
    }

    @DeleteMapping(value={"/{teamId}/permissions/{projectIds}"})
    public void removePermissions(@PathVariable long teamId, @PathVariable List<Long> projectIds) {
        this.permissionService.removeProjectPermission(teamId, projectIds);
    }

    @PostMapping(value={"/{teamId}/members/{logins}"})
    public Map<String, List<TeamMemberDto>> addMembers(@PathVariable long teamId, @PathVariable List<String> logins) {
        this.teamModificationService.addMembers(teamId, logins);
        return Collections.singletonMap("members", this.teamDisplayService.getTeamMembers(Long.valueOf(teamId)));
    }

    @DeleteMapping(value={"/{teamId}/members/{memberIds}"})
    public void removeMember(@PathVariable long teamId, @PathVariable(value="memberIds") List<Long> memberIds) {
        this.teamModificationService.removeMembers(teamId, memberIds);
    }
}

