/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.system;

import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.system.LogFileDownloadService;
import org.squashtest.tm.service.system.SystemAdministrationService;
import org.squashtest.tm.web.backend.controller.system.SystemAdministrationController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/backend/system"})
public class SystemAdministrationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemAdministrationController.class);
    private static final String ATTACHMENT_FILENAME = "attachment; filename=";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String FILENAME = "filename";
    private final SystemAdministrationService systemAdministrationService;
    private final LogFileDownloadService logFileDownloadService;

    SystemAdministrationController(SystemAdministrationService systemAdministrationService, LogFileDownloadService logFileDownloadService) {
        this.systemAdministrationService = systemAdministrationService;
        this.logFileDownloadService = logFileDownloadService;
    }

    @PostMapping(value={"/settings/white-list"})
    void changeWhiteList(@RequestBody SystemSettingsPatch patch) {
        this.systemAdministrationService.changeWhiteList(patch.whiteList());
    }

    @PostMapping(value={"/settings/upload-size-limit"})
    void changeUploadSizeLimit(@RequestBody SystemSettingsPatch patch) {
        this.systemAdministrationService.changeUploadSizeLimit(patch.uploadSizeLimit());
    }

    @PostMapping(value={"/settings/import-size-limit"})
    void changeImportSizeLimit(@RequestBody SystemSettingsPatch patch) {
        this.systemAdministrationService.changeImportSizeLimit(patch.importSizeLimit());
    }

    @PostMapping(value={"/settings/callback-url"})
    void changeCallbackUrl(@RequestBody SystemSettingsPatch patch) {
        this.systemAdministrationService.changeCallbackUrl(patch.callbackUrl());
    }

    @PostMapping(value={"/messages/welcome-message"})
    void changeWelcomeMessage(@RequestBody SystemMessagesPatch patch) {
        this.systemAdministrationService.changeWelcomeMessage(patch.welcomeMessage());
    }

    @PostMapping(value={"/messages/login-message"})
    void changeLoginMessage(@RequestBody SystemMessagesPatch patch) {
        this.systemAdministrationService.changeLoginMessage(patch.loginMessage());
    }

    @PostMapping(value={"/messages/banner-message"})
    void changeBannerMessage(@RequestBody SystemMessagesPatch patch) {
        this.systemAdministrationService.changeBannerMessage(patch.bannerMessage());
    }

    @GetMapping(value={"logs/latest"}, produces={"text/plain"})
    FileSystemResource downloadCurrentLogfile(HttpServletResponse response) {
        File logfile = this.logFileDownloadService.getCurrentLogFile();
        String filename = logfile.getName();
        return SystemAdministrationController.getFileSystemResource((HttpServletResponse)response, (String)filename, (File)logfile);
    }

    @GetMapping(value={"logs"}, params={"filename"}, produces={"text/plain"})
    FileSystemResource downloadLogfile(@RequestParam(value="filename") String filename, HttpServletResponse response) {
        try {
            File logfile = this.logFileDownloadService.getPreviousLogFile(filename);
            return SystemAdministrationController.getFileSystemResource((HttpServletResponse)response, (String)logfile.getName(), (File)logfile);
        }
        catch (IOException e) {
            LOGGER.error("Error downloading log file", (Throwable)e);
            response.setStatus(403);
            return null;
        }
        catch (IllegalStateException e) {
            LOGGER.error("Error downloading log file", (Throwable)e);
            response.setStatus(400);
            return null;
        }
    }

    private static FileSystemResource getFileSystemResource(HttpServletResponse response, String logfile, File logfile1) {
        response.setContentType("text/plain");
        response.setHeader("Content-Disposition", "attachment; filename=" + logfile);
        return new FileSystemResource(logfile1);
    }
}

