/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.sprintreqversion;

import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.campaign.SprintReqVersionValidationStatus;
import org.squashtest.tm.service.campaign.SprintReqVersionModificationService;
import org.squashtest.tm.service.campaign.SprintReqVersionTestPlanManagerService;
import org.squashtest.tm.web.backend.controller.sprintreqversion.SprintReqVersionModificationController;

@RestController
@RequestMapping(value={"/backend/sprint-req-version"})
public class SprintReqVersionModificationController {
    private final SprintReqVersionTestPlanManagerService sprintReqVersionTestPlanManagerService;
    private final SprintReqVersionModificationService sprintReqVersionModificationService;

    public SprintReqVersionModificationController(SprintReqVersionTestPlanManagerService sprintReqVersionTestPlanManagerService, SprintReqVersionModificationService sprintReqVersionModificationService) {
        this.sprintReqVersionTestPlanManagerService = sprintReqVersionTestPlanManagerService;
        this.sprintReqVersionModificationService = sprintReqVersionModificationService;
    }

    @PostMapping(value={"{sprintReqVersionId}/test-plan-items"})
    public void addTestCasesToTestPlan(@PathVariable long sprintReqVersionId, @RequestBody AddTestCasesToTestPlanRequestBody requestBody) {
        if (requestBody.testCaseIds() != null) {
            this.sprintReqVersionTestPlanManagerService.addTestCaseLibraryNodesToTestPlan(Long.valueOf(sprintReqVersionId), requestBody.testCaseIds());
        }
        if (requestBody.datasetIdsByTestCaseId() != null) {
            this.sprintReqVersionTestPlanManagerService.addTestCasesWithDatasetsToTestPlan(Long.valueOf(sprintReqVersionId), requestBody.datasetIdsByTestCaseId());
        }
    }

    @PostMapping(value={"{sprintReqVersionId}/validation-status"})
    public void changeValidationStatus(@PathVariable long sprintReqVersionId, @RequestBody String newValidationStatus) {
        this.sprintReqVersionModificationService.changeValidationStatus(sprintReqVersionId, SprintReqVersionValidationStatus.valueOf((String)newValidationStatus));
    }
}

