/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.sprint;

import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.service.campaign.CustomSprintModificationService;
import org.squashtest.tm.service.campaign.SprintManagerService;
import org.squashtest.tm.service.campaign.SprintModificationService;
import org.squashtest.tm.service.display.sprint.SprintReqVersionDisplayService;
import org.squashtest.tm.service.internal.dto.SprintReqVersionsBindingExceptionSummary;
import org.squashtest.tm.web.backend.controller.sprint.SprintViewModificationController;

@RestController
@RequestMapping(value={"backend/sprint/{sprintId}"})
public class SprintViewModificationController {
    private final CustomSprintModificationService customSprintModificationService;
    private final SprintModificationService sprintModificationService;
    private final SprintManagerService sprintManagerService;
    private final SprintReqVersionDisplayService sprintReqVersionDisplayService;

    public SprintViewModificationController(CustomSprintModificationService customSprintModificationService, SprintModificationService sprintModificationService, SprintManagerService sprintManagerService, SprintReqVersionDisplayService sprintReqVersionDisplayService) {
        this.customSprintModificationService = customSprintModificationService;
        this.sprintModificationService = sprintModificationService;
        this.sprintManagerService = sprintManagerService;
        this.sprintReqVersionDisplayService = sprintReqVersionDisplayService;
    }

    @PostMapping(value={"/name"})
    public void rename(@PathVariable Long sprintId, @RequestBody SprintRecord record) {
        this.customSprintModificationService.rename(sprintId.longValue(), record.name);
    }

    @PostMapping(value={"/reference"})
    public void changeReference(@PathVariable Long sprintId, @RequestBody SprintRecord record) {
        this.sprintModificationService.changeReference(sprintId.longValue(), record.reference);
    }

    @PostMapping(value={"/description"})
    public void changeDescription(@PathVariable Long sprintId, @RequestBody SprintRecord record) {
        this.customSprintModificationService.updateDescription(sprintId.longValue(), record.description);
    }

    @PostMapping(value={"/start-date"})
    public void changeStartDate(@PathVariable Long sprintId, @RequestBody SprintRecord record) {
        this.customSprintModificationService.updateStartDate(sprintId.longValue(), record.startDate);
    }

    @PostMapping(value={"/end-date"})
    public void changeEndDate(@PathVariable Long sprintId, @RequestBody SprintRecord record) {
        this.customSprintModificationService.updateEndDate(sprintId.longValue(), record.endDate);
    }

    @PostMapping(value={"/status"})
    public void changeStatus(@PathVariable Long sprintId, @RequestBody String newStatus) {
        this.customSprintModificationService.updateStatusBySprintId(sprintId, SprintStatus.valueOf((String)newStatus));
    }

    @PostMapping(value={"/denormalize"})
    public void denormalizeSprintReqVersions(@PathVariable Long sprintId) {
        this.customSprintModificationService.denormalizeSprintReqVersions(sprintId);
    }

    @PostMapping(value={"/requirements"})
    public SprintReqVersionsBindingOperationReport bindRequirementsByRlnIds(@PathVariable Long sprintId, @RequestBody List<Long> rlnIds) {
        SprintReqVersionsBindingExceptionSummary summary = new SprintReqVersionsBindingExceptionSummary();
        List sprintReqVersions = this.sprintManagerService.bindRequirementsByRlnIds(sprintId, rlnIds, summary);
        return new SprintReqVersionsBindingOperationReport(sprintReqVersions, summary);
    }

    @PostMapping(value={"/reqversions"})
    public SprintReqVersionsBindingOperationReport bindRequirementsByReqVersionIds(@PathVariable Long sprintId, @RequestBody List<Long> reqVersionIds) {
        SprintReqVersionsBindingExceptionSummary summary = new SprintReqVersionsBindingExceptionSummary();
        List sprintReqVersions = this.sprintManagerService.bindRequirementsByReqVersionIds(sprintId, reqVersionIds, summary);
        return new SprintReqVersionsBindingOperationReport(sprintReqVersions, summary);
    }

    @DeleteMapping(value={"/requirements/{sprintReqVersionIds}"})
    public SprintReqVersionsBindingOperationReport removeSprintReqVersions(@PathVariable long sprintId, @PathVariable List<Long> sprintReqVersionIds) {
        this.sprintManagerService.deleteSprintReqVersions(sprintId, sprintReqVersionIds);
        List sprintReqVersionDtos = this.sprintReqVersionDisplayService.findSprintReqVersionDtosBySprintId(sprintId);
        return new SprintReqVersionsBindingOperationReport(sprintReqVersionDtos, null);
    }
}

