/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.scm.server;

import jakarta.inject.Inject;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.core.scm.api.exception.ScmException;
import org.squashtest.tm.exception.scmserver.ScmPluginException;
import org.squashtest.tm.service.display.scm.server.ScmServerDisplayService;
import org.squashtest.tm.service.internal.display.dto.ScmRepositoryDto;
import org.squashtest.tm.service.scmserver.ScmRepositoryManagerService;
import org.squashtest.tm.web.backend.controller.form.model.ScmRepositoryFormModel;
import org.squashtest.tm.web.backend.controller.scm.server.ScmRepositoryManagementController;

@RestController
@RequestMapping(value={"/backend/scm-repositories"})
public class ScmRepositoryManagementController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScmRepositoryManagementController.class);
    ScmRepositoryManagerService scmRepositoryManager;
    ScmServerDisplayService scmServerDisplayService;

    @Inject
    ScmRepositoryManagementController(ScmRepositoryManagerService scmRepositoryManager, ScmServerDisplayService scmServerDisplayService) {
        this.scmRepositoryManager = scmRepositoryManager;
        this.scmServerDisplayService = scmServerDisplayService;
    }

    @PostMapping(value={"/{scmServerId}/new"})
    public Map<String, List<ScmRepositoryDto>> createNewScmRepository(@PathVariable long scmServerId, @RequestBody ScmRepositoryFormModel scmRepositoryFormModel) throws IOException {
        try {
            this.scmRepositoryManager.createNewScmRepository(scmServerId, scmRepositoryFormModel.name(), scmRepositoryFormModel.workingBranch(), scmRepositoryFormModel.workingFolderPath(), scmRepositoryFormModel.cloneRepository());
        }
        catch (ScmException ex) {
            LOGGER.error("Error while creating new SCM repository", (Throwable)ex);
            throw new ScmPluginException(ex.getField(), (Exception)((Object)ex));
        }
        List repositories = this.scmServerDisplayService.getScmServerView(scmServerId).getRepositories();
        return Collections.singletonMap("repositories", repositories);
    }

    @PostMapping(value={"/{scmServerId}/{scmRepositoryId}/branch"})
    public Map<String, List<ScmRepositoryDto>> updateBranch(@PathVariable long scmServerId, @PathVariable long scmRepositoryId, @RequestBody ScmRepositoryPatch patch) throws IOException {
        try {
            this.scmRepositoryManager.updateBranch(scmRepositoryId, patch.getBranch());
        }
        catch (ScmException ex) {
            throw new ScmPluginException(ex.getField(), (Exception)((Object)ex));
        }
        List repositories = this.scmServerDisplayService.getScmServerView(scmServerId).getRepositories();
        return Collections.singletonMap("repositories", repositories);
    }

    @DeleteMapping(value={"/{scmRepositoriesIds}"})
    public void deleteScmRepositories(@PathVariable List<Long> scmRepositoriesIds) {
        this.scmRepositoryManager.deleteScmRepositories(scmRepositoriesIds);
    }

    @GetMapping(value={"check-bound-to-project/{scmRepositoryIds}"})
    public boolean isOneRepositoryBoundToProject(@PathVariable Collection<Long> scmRepositoryIds) {
        return this.scmRepositoryManager.isOneRepositoryBoundToProjectOrTestCase(scmRepositoryIds);
    }

    @PostMapping(value={"/{scmRepositoryId}/recreate-local-repository"})
    public void recloneScmRepository(@PathVariable long scmRepositoryId) {
        this.scmRepositoryManager.recloneScmRepository(scmRepositoryId);
    }
}

