/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.requirements.links;

import jakarta.inject.Inject;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.exception.WrongStringSizeException;
import org.squashtest.tm.service.requirement.RequirementVersionLinkTypeManagerService;
import org.squashtest.tm.web.backend.controller.requirements.links.RequirementsLinkModificationController;

@RestController
@RequestMapping(value={"/backend/requirement-link-type/{requirementLinkTypeId}"})
public class RequirementsLinkModificationController {
    @Inject
    private RequirementVersionLinkTypeManagerService requirementVersionLinkTypeManagerService;

    @PostMapping(value={"/role"})
    public void changeRole1(@PathVariable long requirementLinkTypeId, @RequestBody RequirementLinkTypePatch patch) {
        if (patch.getRole().length() > 50) {
            throw new WrongStringSizeException("role1", 0, 50);
        }
        this.requirementVersionLinkTypeManagerService.changeRole1(Long.valueOf(requirementLinkTypeId), patch.getRole());
    }

    @PostMapping(value={"/role1Code"})
    public void changeRole1Code(@PathVariable long requirementLinkTypeId, @RequestBody RequirementLinkTypePatch patch) {
        if (patch.getRole1Code().length() > 30) {
            throw new WrongStringSizeException("role1Code", 0, 30);
        }
        this.requirementVersionLinkTypeManagerService.changeCode1(Long.valueOf(requirementLinkTypeId), patch.getRole1Code());
    }

    @PostMapping(value={"/role2"})
    public void changeRole2(@PathVariable long requirementLinkTypeId, @RequestBody RequirementLinkTypePatch patch) {
        if (patch.getRole2().length() > 50) {
            throw new WrongStringSizeException("role2", 0, 50);
        }
        this.requirementVersionLinkTypeManagerService.changeRole2(Long.valueOf(requirementLinkTypeId), patch.getRole2());
    }

    @PostMapping(value={"/role2Code"})
    public void changeRole2Code(@PathVariable long requirementLinkTypeId, @RequestBody RequirementLinkTypePatch patch) {
        if (patch.getRole2Code().length() > 30) {
            throw new WrongStringSizeException("role2Code", 0, 30);
        }
        this.requirementVersionLinkTypeManagerService.changeCode2(Long.valueOf(requirementLinkTypeId), patch.getRole2Code());
    }

    @PostMapping(value={"/default"})
    public void changeDefault(@PathVariable long requirementLinkTypeId) {
        this.requirementVersionLinkTypeManagerService.changeDefault(Long.valueOf(requirementLinkTypeId));
    }
}

