/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.requirement;

import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.service.annotation.CheckEntityExists;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.display.requirements.RequirementDisplayService;
import org.squashtest.tm.service.internal.display.dto.requirement.AbstractRequirementVersionDto;
import org.squashtest.tm.service.internal.display.dto.requirement.HighLevelRequirementVersionDto;
import org.squashtest.tm.service.internal.display.dto.requirement.RequirementVersionBundleStatsDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.requirement.RequirementVersionManagerService;
import org.squashtest.tm.web.backend.controller.requirement.RequirementViewController;

@RestController
@RequestMapping(path={"backend/requirement-view"})
public class RequirementViewController {
    private final RequirementDisplayService requirementDisplayService;
    private final RequirementVersionManagerService versionManagerService;
    private final ActiveMilestoneHolder activeMilestoneHolder;

    public RequirementViewController(RequirementDisplayService requirementDisplayService, RequirementVersionManagerService versionManagerService, ActiveMilestoneHolder activeMilestoneHolder) {
        this.requirementDisplayService = requirementDisplayService;
        this.versionManagerService = versionManagerService;
        this.activeMilestoneHolder = activeMilestoneHolder;
    }

    @GetMapping(path={"/current-version/{requirementId}"})
    @CheckEntityExists(entityType=Requirement.class)
    public AbstractRequirementVersionDto findCurrentVersion(@PathVariable @Id Long requirementId) {
        return this.requirementDisplayService.findCurrentVersionView(requirementId);
    }

    @GetMapping(path={"high-level/current-version/{requirementId}"})
    public HighLevelRequirementVersionDto findHighLevelCurrentVersion(@PathVariable Long requirementId) {
        return this.requirementDisplayService.findHighLevelCurrentVersionView(requirementId);
    }

    @GetMapping(path={"/{requirementVersionId}"})
    public AbstractRequirementVersionDto findVersion(@PathVariable Long requirementVersionId) {
        return this.requirementDisplayService.findVersionView(requirementVersionId);
    }

    @GetMapping(path={"/{requirementVersionId}/statistics"})
    public RequirementVersionBundleStatsDto getRequirementVersionStatistics(@PathVariable Long requirementVersionId) {
        return this.requirementDisplayService.computeRequirementVersionStatistics(requirementVersionId);
    }

    @GetMapping(path={"/{requirementVersionId}/issues-count"})
    public Integer getRequirementVersionIssuesCount(@PathVariable Long requirementVersionId) {
        return this.requirementDisplayService.countIssuesByRequirementVersionId(requirementVersionId);
    }

    @PostMapping(path={"/versions/{requirementId}"})
    public GridResponse findRequirementVersions(@PathVariable Long requirementId, @RequestBody GridRequest request) {
        return this.requirementDisplayService.findVersionsByRequirementId(requirementId, request);
    }

    @PostMapping(path={"/{requirementId}/new"})
    public AbstractRequirementVersionDto createNewVersion(@PathVariable Long requirementId, @RequestBody NewReqVersionParams params) {
        Optional activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        if (activeMilestone.isPresent()) {
            ArrayList<Long> milestoneIds = new ArrayList<Long>();
            milestoneIds.add(((Milestone)activeMilestone.get()).getId());
            this.versionManagerService.createNewVersion(requirementId.longValue(), milestoneIds, params.isInheritReqLinks(), params.isInheritTestCases());
        } else {
            this.versionManagerService.createNewVersion(requirementId.longValue(), params.isInheritReqLinks(), params.isInheritTestCases());
        }
        return this.requirementDisplayService.findCurrentVersionView(requirementId);
    }
}

