/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.requirement;

import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.users.PartyPreference;
import org.squashtest.tm.domain.users.preferences.CorePartyPreference;
import org.squashtest.tm.service.customreport.CustomReportDashboardService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.internal.display.dto.customreports.CustomReportDashboardDto;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportDashboard;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.service.user.PartyPreferenceService;
import org.squashtest.tm.web.backend.controller.requirement.RequirementMilestoneDashboardController;
import org.squashtest.tm.web.backend.model.builder.JsonCustomReportDashboardBuilder;

@RestController
@RequestMapping(value={"/backend/requirement-milestone-dashboard"})
public class RequirementMilestoneDashboardController {
    private final RequirementLibraryNavigationService requirementLibraryNavigationService;
    private final ActiveMilestoneHolder activeMilestoneHolder;
    private final CustomReportLibraryNodeService customReportLibraryNodeService;
    @Named(value="customReport.dashboardBuilder")
    private final Provider<JsonCustomReportDashboardBuilder> builderProvider;
    private final CustomReportDashboardService customReportDashboardService;
    private final PartyPreferenceService partyPreferenceService;

    public RequirementMilestoneDashboardController(RequirementLibraryNavigationService requirementLibraryNavigationService, ActiveMilestoneHolder activeMilestoneHolder, CustomReportLibraryNodeService customReportLibraryNodeService, Provider<JsonCustomReportDashboardBuilder> builderProvider, CustomReportDashboardService customReportDashboardService, PartyPreferenceService partyPreferenceService) {
        this.requirementLibraryNavigationService = requirementLibraryNavigationService;
        this.activeMilestoneHolder = activeMilestoneHolder;
        this.customReportLibraryNodeService = customReportLibraryNodeService;
        this.builderProvider = builderProvider;
        this.customReportDashboardService = customReportDashboardService;
        this.partyPreferenceService = partyPreferenceService;
    }

    @GetMapping
    public RequirementMilestoneDashboard getDashboardByMilestone(Locale locale) {
        RequirementMilestoneDashboard requirementMilestoneDashboard = new RequirementMilestoneDashboard();
        boolean canShowDashboardInWorkspace = this.customReportDashboardService.canShowDashboardInWorkspace(Workspace.REQUIREMENT);
        boolean shouldShowFavoriteDashboardInWorkspace = this.customReportDashboardService.shouldShowFavoriteDashboardInWorkspace(Workspace.REQUIREMENT);
        requirementMilestoneDashboard.setCanShowFavoriteDashboard(canShowDashboardInWorkspace);
        requirementMilestoneDashboard.setShouldShowFavoriteDashboard(shouldShowFavoriteDashboardInWorkspace);
        if (shouldShowFavoriteDashboardInWorkspace) {
            if (canShowDashboardInWorkspace) {
                PartyPreference preference = this.partyPreferenceService.findPreferenceForCurrentUser(CorePartyPreference.FAVORITE_DASHBOARD_REQUIREMENT.getPreferenceKey());
                Long dashboardId = Long.valueOf(preference.getPreferenceValue());
                CustomReportDashboard dashboard = this.customReportLibraryNodeService.findCustomReportDashboardById(dashboardId);
                CustomReportDashboardDto dashboardScope = new CustomReportDashboardDto(Workspace.REQUIREMENT, Collections.emptyList(), true);
                JsonCustomReportDashboard jsonDashboard = ((JsonCustomReportDashboardBuilder)this.builderProvider.get()).build(dashboardId, dashboard, locale, dashboardScope);
                requirementMilestoneDashboard.setDashboard(jsonDashboard);
                requirementMilestoneDashboard.setFavoriteDashboardId(dashboardId);
            }
        } else {
            Milestone activeMilestone = this.activeMilestoneHolder.getActiveMilestone().orElse(null);
            List nodeIds = this.requirementLibraryNavigationService.findAllRequirementIdsInMilestone(activeMilestone);
            requirementMilestoneDashboard.setStatistics(this.requirementLibraryNavigationService.getStatisticsForSelection(new ArrayList(), (Collection)nodeIds));
        }
        return requirementMilestoneDashboard;
    }
}

