/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.requirement;

import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.util.Collections;
import java.util.Locale;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.display.requirements.RequirementDisplayService;
import org.squashtest.tm.service.internal.display.dto.customreports.CustomReportDashboardDto;
import org.squashtest.tm.service.internal.display.dto.requirement.RequirementLibraryDto;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportDashboard;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.web.backend.model.builder.JsonCustomReportDashboardBuilder;

@RestController
@RequestMapping(value={"backend/requirement-library-view"})
public class RequirementLibraryViewController {
    private final RequirementLibraryNavigationService requirementLibraryNavigationService;
    private final RequirementDisplayService requirementDisplayService;
    private final CustomReportLibraryNodeService customReportLibraryNodeService;
    @Named(value="customReport.dashboardBuilder")
    private final Provider<JsonCustomReportDashboardBuilder> builderProvider;

    public RequirementLibraryViewController(RequirementDisplayService requirementDisplayService, RequirementLibraryNavigationService requirementLibraryNavigationService, CustomReportLibraryNodeService customReportLibraryNodeService, Provider<JsonCustomReportDashboardBuilder> builderProvider) {
        this.requirementDisplayService = requirementDisplayService;
        this.requirementLibraryNavigationService = requirementLibraryNavigationService;
        this.customReportLibraryNodeService = customReportLibraryNodeService;
        this.builderProvider = builderProvider;
    }

    @GetMapping(value={"/{requirementLibraryId}"})
    public RequirementLibraryDto getRequirementLibrary(@PathVariable long requirementLibraryId, Locale locale, @RequestParam boolean extendHighLvlReqScope) {
        RequirementLibraryDto dto = this.requirementDisplayService.findLibrary(requirementLibraryId);
        if (dto.isShouldShowFavoriteDashboard()) {
            if (dto.isCanShowFavoriteDashboard()) {
                EntityReference library = new EntityReference(EntityType.REQUIREMENT_LIBRARY, Long.valueOf(requirementLibraryId));
                CustomReportDashboard dashboard = this.customReportLibraryNodeService.findCustomReportDashboardById(dto.getFavoriteDashboardId());
                CustomReportDashboardDto dashboardDto = new CustomReportDashboardDto(Workspace.REQUIREMENT, Collections.singletonList(library), false, extendHighLvlReqScope, false);
                JsonCustomReportDashboard jsonDashboard = ((JsonCustomReportDashboardBuilder)this.builderProvider.get()).build(dto.getFavoriteDashboardId(), dashboard, locale, dashboardDto);
                dto.setDashboard(jsonDashboard);
            }
        } else {
            dto.setStatistics(this.requirementLibraryNavigationService.getStatisticsForSelection(Collections.singleton(requirementLibraryId), Collections.emptyList(), extendHighLvlReqScope));
        }
        return dto;
    }
}

