/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.report;

import java.util.List;
import org.squashtest.tm.api.report.form.BasicInput;
import org.squashtest.tm.api.report.form.DateInput;
import org.squashtest.tm.api.report.form.Input;
import org.squashtest.tm.api.report.form.InputType;
import org.squashtest.tm.api.report.form.InputsGroup;
import org.squashtest.tm.web.backend.controller.report.BasicInputJson;
import org.squashtest.tm.web.backend.controller.report.InputJson;

public class InputsGroupJson
implements InputJson {
    private final String label;
    private final String name;
    private final InputType type;
    private final boolean required;
    private List<InputJson> inputs;

    public InputsGroupJson(InputsGroup group) {
        this.label = group.getLabel();
        this.name = group.getName();
        this.type = group.getType();
        this.required = group.isRequired();
        this.inputs = group.getInputs().stream().map(InputsGroupJson::fromInput).toList();
    }

    private static InputJson fromInput(Input input) {
        if (InputType.DATE.equals((Object)input.getType())) {
            DateInput dateInput = (DateInput)input;
            return new BasicInputJson((BasicInput)dateInput);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public InputType getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public List<InputJson> getInputs() {
        return this.inputs;
    }

    public String getLabel() {
        return this.label;
    }
}

