/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.project;

import jakarta.validation.Valid;
import java.util.Collections;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.project.ProjectTemplate;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.project.ProjectManagerService;
import org.squashtest.tm.web.backend.model.json.JsonProjectFromTemplate;

@RestController
@RequestMapping(value={"/backend/projects"})
public class ProjectController {
    private final ProjectManagerService projectManager;
    private final GenericProjectManagerService genericProjectManager;

    public ProjectController(ProjectManagerService projectManager, GenericProjectManagerService genericProjectManager) {
        this.projectManager = projectManager;
        this.genericProjectManager = genericProjectManager;
    }

    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping(value={"/new"})
    public Map<String, Object> createProjectFromTemplate(@Valid @RequestBody JsonProjectFromTemplate jsonProjectFromTemplate) {
        try {
            if (jsonProjectFromTemplate.isFromTemplate()) {
                this.projectManager.addProjectFromTemplate(jsonProjectFromTemplate.getProject(), jsonProjectFromTemplate.getTemplateId(), jsonProjectFromTemplate.getParams());
                return Collections.singletonMap("id", jsonProjectFromTemplate.getProject().getId());
            }
            Project project = jsonProjectFromTemplate.getProject();
            this.genericProjectManager.persist((GenericProject)project);
            this.genericProjectManager.createAttachmentFromDescription((GenericProject)project);
            return Collections.singletonMap("id", project.getId());
        }
        catch (NameAlreadyInUseException ex) {
            ex.setObjectName("add-project-from-template");
            throw ex;
        }
    }

    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping(value={"/new-template"})
    public Map<String, Object> createNewTemplate(@RequestBody @Valid ProjectTemplate template) {
        try {
            this.genericProjectManager.persist((GenericProject)template);
            this.genericProjectManager.createAttachmentFromDescription((GenericProject)template);
            return Collections.singletonMap("id", template.getId());
        }
        catch (NameAlreadyInUseException ex) {
            ex.setObjectName("add-template");
            throw ex;
        }
    }

    @DeleteMapping(value={"/{projectId}"})
    public void deleteProject(@PathVariable long projectId) {
        this.projectManager.deleteProject(projectId);
    }

    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping(value={"coerce-into-template"})
    public void coerceProjectIntoTemplate(@RequestBody Map<String, Long> payload) {
        long projectId = payload.get("projectId");
        this.genericProjectManager.coerceProjectIntoTemplate(projectId);
    }
}

